### R code from vignette source 'clifford.Rnw'

###################################################
### code chunk number 1: setup
###################################################
library("clifford")


###################################################
### code chunk number 2: simpleexample
###################################################
(x <- clifford(list(numeric(0),1,2,2:3),1:4))


###################################################
### code chunk number 3: xminusy
###################################################
y <- clifford(list(1),2)
x-y


###################################################
### code chunk number 4: xtimesy
###################################################
x*x


###################################################
### code chunk number 5: ztimesx
###################################################
(z <- as.1vector(1:7))
z*x


###################################################
### code chunk number 6: firstuseofrcliff
###################################################
rcliff()


###################################################
### code chunk number 7: anotherrcliff
###################################################
(x <- rcliff(d=7,g=5,include.fewer=TRUE))
grades(x)


###################################################
### code chunk number 8: e1e2cliff
###################################################
e1 <- basis(1)
e2 <- basis(2)
e1*e1
e2*e2


###################################################
### code chunk number 9: trysig
###################################################
signature(1)  # signature +-
e1*e1 # as before
e2*e2 # sign changes


###################################################
### code chunk number 10: sigthree1
###################################################
x <- rcliff(d=4,g=3,include.fewer=TRUE)
y <- rcliff(d=4,g=3,include.fewer=TRUE)


###################################################
### code chunk number 11: sigthree2
###################################################
x*y
signature(3)  # switch to signature +++-
x*y


###################################################
### code chunk number 12: grassmanalgebra
###################################################
signature(-1)  # specify null inner product


###################################################
### code chunk number 13: clifford.Rnw:324-325
###################################################
is.zero(basis(5)^2)     # should be TRUE


###################################################
### code chunk number 14: reproducewedge
###################################################
x <- clifford(list(1:3, c(2,3,7)), 3:4)
y <- clifford(list(1:3, c(1,4,5), c(4,5,6)), 1:3)
x %^% y


###################################################
### code chunk number 15: sigzero
###################################################
signature(0)


###################################################
### code chunk number 16: clifford.Rnw:379-380
###################################################
basis(53)^2


###################################################
### code chunk number 17: clifford.Rnw:402-406
###################################################
(A <- rcliff())
(B <- rcliff())
A %_|% B
A %|_% B


###################################################
### code chunk number 18: clifford.Rnw:412-413
###################################################
e(2) %_|% e(1)*e(2)


###################################################
### code chunk number 19: clifford.Rnw:419-420
###################################################
e(2) %_|% (e(1)*e(2))


###################################################
### code chunk number 20: clifford.Rnw:425-426
###################################################
e(2) %_|% e(1:2)


###################################################
### code chunk number 21: clifford.Rnw:442-446
###################################################
A <- rcliff();  B <- rcliff();  C <- rcliff()
A %_|% (B %|_% C) == (A %_|% B) %|_% C
A %_|% (B %_|% C) == (A %^%  B) %_|% C
A %|_% (B %^%  C) == (A %|_% B) %|_% C


###################################################
### code chunk number 22: printmethodchange
###################################################
options("basissep" = ",")


###################################################
### code chunk number 23: abramandfauser
###################################################
(x <- clifford(list(1:3,c(1,5,7,8,10)),c(4,-10)) + 2)
(y <- clifford(list(c(1,2,3,7),c(1,5,6,8),c(1,4,6,7)),c(4,1,-3)) - 1)


###################################################
### code chunk number 24: geomprod
###################################################
signature(7)
x*y


