% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/cfQuery.R
\name{cf_last_query}
\alias{cf_last_query}
\title{Retrieve Last Query Result from CliFlo}
\usage{
cf_last_query()
}
\description{
Retrieve the last query submitted to CliFlo instead of querying the database
again and losing subscription rows.
}
\details{
This function is a back up for when the clifro query has been submitted and
the data returned but has not been assigned, or inadvertantly deleted. This
saves the user resubmitting queries and using more rows from their
subscription than needed.
}
\note{
Only the data from the last query is saved in \code{clifro}.
}
\examples{
\dontrun{
# Query CliFlo for wind at Reefton Ews
cf_query(cf_user(), cf_datatype(2, 1, 1, 1), cf_station(), "2012-01-01 00")

# Oops! Forgot to assign it to a variable...
reefton.wind = cf_last_query()
reefton.wind
}
}

