% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfUser.R
\docType{package}
\name{clifro}
\alias{clifro}
\alias{clifro-package}
\title{From CliFlo to \pkg{clifro}: Enhancing The National Climate Database With \R}
\description{
Import data from New Zealand's National Climate Database via CliFlo into \R
for exploring, analysis, plotting, exporting to KML, CSV, or other software.
}
\details{
The \pkg{clifro} package is intended to simplify the process of data
extraction, formatting and visualisation from the
\href{https://cliflo.niwa.co.nz/}{CliFlo web portal}. It
requires the user to build a query consisting of 3 main components; the user,
the datatype(s) and the station(s). These are
then combined using the \code{\link{cf_query}} function that sends the query
to the CliFlo database and returns the results that can easily be plotted
using generic plotting functions.

This package requires the user to already have a current subscription to the
National Climate Database unless a public user is sought, where data is
limited to Reefton Ews. Subscription is free and can obtained from
\url{https://cliflo.niwa.co.nz/pls/niwp/wsubform.intro}.
}
\examples{
\dontrun{
# Create a public user ----------------------------------------------------

public.user = cf_user() # Defaults to "public"
public.user

# Select datatypes --------------------------------------------------------

# 9am Surface wind (m/s)
wind.dt = cf_datatype(2, 1, 4, 1)

# Daily Rain
rain.dt = cf_datatype(3, 1, 1)

# Daily temperature extremes
temp.dt = cf_datatype(4, 2, 2)

# Combine them together
all.dts = wind.dt + rain.dt + temp.dt
all.dts

# Select the Reefton Ews station ------------------------------------------

reefton.st = cf_station()
reefton.st

# Submit the query --------------------------------------------------------

# Retrieve all data from ~ six months ago at 9am
reefton.data = cf_query(public.user, all.dts, reefton.st,
                        paste(as.Date(Sys.time()) - 182, "9"))
reefton.data


# Plot the data -----------------------------------------------------------

# Plot the 9am surface wind data (first dataframe in the list) ---
reefton.data[1]

# all identical - although passed to different methods
plot(reefton.data)    #plot,cfDataList,missing-method
plot(reefton.data, 1) #plot,cfDataList,numeric-method
plot(reefton.data[1]) #plot,cfData,missing-method --> plot,cfWind,missing-method

speed_plot(reefton.data)
direction_plot(reefton.data)

# Plot the daily rain data (second dataframe in the list) ---
reefton.data[2]

# With runoff and soil deficit
plot(reefton.data, 2)

# Just plot amount of rain (mm)
plot(reefton.data, 2, include_runoff = FALSE)

# Plot the hourly temperature data (third dataframe in the list) ---
plot(reefton.data, 3)

# Pass an argument to ggplot2::theme
library(ggplot2) # for element_text()
plot(reefton.data, 3, text = element_text(size = 18))
}
}
\seealso{
\code{\link{cf_user}}, \code{\link{cf_datatype}}, and
  \code{\link{cf_station}} for choosing the clifro user, datatypes and
  stations, respectively.
}
\keyword{package}
