% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/climaemet_main.R
\name{windrose_days}
\alias{windrose_days}
\title{Windrose (speed/direction) diagram of a station over a days period}
\usage{
windrose_days(
  station,
  apikey,
  start = "2000-12-31",
  end = "2000-12-31",
  n_directions = 8,
  n_speeds = 5,
  speed_cuts = NA,
  col_pal = "GnBu",
  calm_wind = 0,
  legend_title = "Wind Speed (m/s)"
)
}
\arguments{
\item{station}{Character string as station identifier code (see \code{\link{aemet_stations}}).}

\item{apikey}{Character string as personal API key (see \url{https://opendata.aemet.es/centrodedescargas/obtencionAPIKey}).}

\item{start}{Character string as start date (format: \%Y\%m\%d).}

\item{end}{Character string as end date (format: \%Y\%m\%d).}

\item{n_directions}{Numeric value as number of direction bins to plot (default = 8).}

\item{n_speeds}{Numeric value as number of equally spaced wind speed bins to plot (default = 5).}

\item{speed_cuts}{Numeric vector containing the cut points for the wind speed intervals, or \code{NA} (default).}

\item{col_pal}{Character string indicating the name of the \code{\link[RColorBrewer]{brewer.pal.info}} colour palette to be used for plotting.}

\item{calm_wind}{Numeric value as the upper limit for wind speed that is considered calm (default = 0).}

\item{legend_title}{Character string to be used for the legend title.}
}
\value{
a plot.
}
\description{
Plot a windrose showing the wind speed and direction for a station over a days period.
}
\examples{
\dontrun{
windrose_days(station, apikey, start = "2000-01-01", end = "2000-12-31")
}

}
\seealso{
See more details in the "ggwindrose" function \code{\link{ggwindrose}}.
}
