% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ce_download.R
\name{ce_download}
\alias{ce_download}
\title{Download climate and elevation data}
\usage{
ce_download(
  output_dir,
  c_source = "WorldClim",
  e_source = "mapzen",
  var = "all",
  location,
  ...
)
}
\arguments{
\item{output_dir}{Character (e.g., \code{"../Desktop/chelsa"}). Pathway to where
the data will be stored.}

\item{c_source}{Character (e.g., \code{"CHELSA or WorldClim"}). Indicating the
climate data source.}

\item{e_source}{Character (e.g., \code{mapzen} or \code{geodata}). Indicating the
elevation data source.}

\item{var}{Character. If supplied will download a subset of the climate data.
Must be one of \code{"all"} (default), \code{"prec"}, \code{"tmax"}, \code{"tmin"} or \code{"tmean"}
to download the corresponding climate data.}

\item{location}{A \code{"sp"}, \code{"sf"} polygon or point object. See
\link[sf:st]{sf::st_polygon} to make polygons and \link[sf:st_as_sf]{sf::st_as_sf} to make point
objects.}

\item{\dots}{Arguments to control a download from the Internet
\code{download.file()}.}
}
\value{
See documentation from \code{\link[=chelsa]{chelsa()}}, \code{\link[=worldclim]{worldclim()}} and
\code{\link[=elev]{elev()}}.
}
\description{
\code{ce_download()} brings together the \code{worldclim()},
\code{chelsa()} and \code{elev()} functions to streamline downloading.
}
\examples{
\donttest{
# Download time will depend on the size of the area you wish to access
# climate data for and your internet connection speed.

# Make a polygon file
regents <- sf::st_polygon(
  list(
    cbind(
      "lon" = c(51.537, 51.525, 51.523, 51.530, 51.534, 51.537),
      "lat" = c(-0.150, -0.145, -0.156, -0.167, -0.163, -0.150)
    )
  )
)

# Create temporary output directory
temp_path <- tempdir()

# Run the download function
ce_download(
  output_dir = temp_path,
  location = regents
)

# Reset user options
unlink(file.path(temp_path))

}
}
\seealso{
The underlying functions \code{\link[=chelsa]{chelsa()}}, \code{\link[=worldclim]{worldclim()}} and
\code{\link[=elev]{elev()}}.
}
\author{
James L. Tsakalos and Martin R. Smith
}
