% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_ratio.R
\name{calc_riskRatio_binom}
\alias{calc_riskRatio_binom}
\title{Compute risk ratio and uncertainty based on binomial models for counts of events relative to possible number of events}
\usage{
calc_riskRatio_binom(y, n, ciLevel = 0.9, bootSE = FALSE,
  bootControl = list(seed = 0, n = 500), lrtCI = FALSE,
  lrtControl = list(bounds = c(0.01, 100)))
}
\arguments{
\item{y}{vector of two values, the number of events in the two scenarios}

\item{n}{vector of two values, the number of samples (possible occurrences of events) in the two scenarios}

\item{ciLevel}{statistical confidence level for confidence intervals; in repeated experimentation, this proportion of confidence intervals should contain the true risk ratio. Note that if only one endpoint of the resulting interval is used, for example the lower bound, then the effective confidence level increases by half of one minus \code{ciLevel}. For example, a two-sided 0.90 confidence interval corresponds to a one-sided 0.95 confidence interval.}

\item{bootSE}{logical indicating whether to use the bootstrap to estimate standard errors.}

\item{bootControl}{a list of control parameters for the bootstrapping. See \code{Details}.}

\item{lrtCI}{logical indicating whether to calculate a likelihood ratio-based confidence interval}

\item{lrtControl}{list containing a single component, \code{bounds}, which sets the range inside which the algorithm searches for the endpoints of the likelihood ratio-based confidence interval. This avoids numerical issues with endpoints converging to zero and infinity. If an endpoint is not found within the interval, it is set to \code{NA}.}
}
\description{
Compute risk ratio and uncertainty by fitting binomial models to counts of events relative to possible number of events. The risk ratio is the ratio of the probability of an event under the model fit to the first dataset to the probability under the model fit to the second dataset. Default standard errors are based on the usual MLE asymptotics using a delta-method-based approximation, but standard errors based on the nonparametric bootstrap and on a likelihood ratio procedure can also be computed.
}
\details{
See \code{\link{fit_pot}} for information on the \code{bootControl} argument.
}
\examples{
calc_riskRatio_binom(c(4,0), rep(100, 2), bootSE = FALSE, lrtCI = TRUE)
calc_riskRatio_binom(c(40, 8), rep(400, 2), bootSE = TRUE, lrtCI = TRUE)
}
\author{
Christopher J. Paciorek
}
\references{
Paciorek et al. methods paper being finalized.
}

