% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/singlewin.R
\name{singlewin}
\alias{singlewin}
\title{Fit a single climate window}
\usage{
singlewin(Xvar, CDate, BDate, baseline, furthest, closest, STAT, FUNC, FIXED,
  cutoff.day, cutoff.month, CMISSING = FALSE, CINTERVAL = "D")
}
\arguments{
\item{Xvar}{The climate variable of interest. Please specify the parent
environment and variable name (e.g. Climate$Temp).}

\item{CDate}{The climate date variable (dd/mm/yyyy). Please specify the parent
environment and variable name (e.g. Climate$Date).}

\item{BDate}{The biological date variable (dd/mm/yyyy). Please specify the
parent environment and variable name (e.g. Biol$Date).}

\item{baseline}{The baseline model structure used for testing correlation.
Currently known to support lm, glm, lmer and glmer objects.}

\item{furthest}{The start day of the single window.}

\item{closest}{The end day of the single window.}

\item{STAT}{The aggregate statistic used to analyse the climate data. Can
currently use basic R statistics (e.g. mean, min), as well as slope.
Additional aggregate statistics can be created using the format function(x)
(...). See FUN in \code{\link{apply}} for more detail.}

\item{FUNC}{The function used to fit the climate variable in the model. Can be
linear ("L"), quadratic ("Q"), cubic ("C"), inverse ("I") or log ("LOG").}

\item{FIXED}{TRUE or FALSE, whether you wish the climate window to be variable
(i.e. the number of days before each biological record is measured) or fixed
(i.e. number of days before a set point in time).}

\item{cutoff.day,cutoff.month}{If FIXED is TRUE, the day and month of the year
from which the fixed window analysis will start.}

\item{CMISSING}{TRUE or FALSE, determines what should be done if there are
missing climate data. If FALSE, the function will not run if missing climate
data is encountered. If TRUE, any records affected by missing climate data
will be removed from climate window analysis.}

\item{CINTERVAL}{The resolution at which climate window analysis will be
conducted. May be days ("D"), weeks ("W"), or months ("M"). Note the units
of parameters 'furthest' and 'closest' will differ depending on the choice
of CINTERVAL.}
}
\value{
Will return a list containing two objects:

 \itemize{ \item SingleBestModel, a model object of the fitted climate window
 model.

 \item SingleBestModelData, a dataframe with the biological and climate data
 used to fit the climate window model.}
}
\description{
Fit a single climate window with a known start and end time.
}
\examples{
\dontrun{
# Fit a known climate window to the datasets Mass and MassClimate

data(Mass)
data(MassClimate)

# Test for a fixed climate window, starting from 20th May
# Fit a climate window starting 72 days ago and ending 15 days ago
# Fit a linear term for the mean climate
# Fit climate windows at the resolution of days

single <- singlewin(Xvar = MassClimate$Temp, CDate = MassClimate$Date, BDate = Mass$Date,
                   baseline = lm(Mass ~ 1, data = Mass), furthest = 72, closest = 15,
                   STAT = "mean", FUNC = "L",
                   FIXED = TRUE, cutoff.day = 20, cutoff.month = 5,
                   CMISSING = FALSE, CINTERVAL = "D")

##View data##
single[[1]]
head(single[[2]])
}
}
\author{
Liam D. Bailey and Martijn van de Pol
}

