% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting-render-utility.R
\name{getMdFromConfig}
\alias{getMdFromConfig}
\title{Get path of the \code{HTML} file corresponding
to a specific config file.}
\usage{
getMdFromConfig(
  configFiles,
  indexPath = "index.Rmd",
  intermediateDir = "./interim"
)
}
\arguments{
\item{configFiles}{Character vector with name or path of the config file(s).}

\item{indexPath}{String with path to the index file,
by default 'index.Rmd' in \code{inputDir}.}

\item{intermediateDir}{String with intermediate directory ('interim'
by default), where
markdown files and rds file specifying Js libraries (with \code{knit_meta}) for
each sub report are stored.}
}
\value{
String with path to the HTML file
}
\description{
The name of the \code{Markdown} file is based on:
\itemize{
\item{for the general \code{config.yml} file: }{
the basename of the specified \code{indexPath}}
\item{for other config file (each sub-report): }{
the name of the config file, after removal of the
'\code{config-}' part.}
}
}
\author{
Laure Cougnaud
}
