% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-utility-dimensions.R
\name{getSizePlot}
\alias{getSizePlot}
\title{Get dimensions for a clinical data plot}
\usage{
getSizePlot(
  width = NULL,
  height = NULL,
  gg = NULL,
  nrow = 1L,
  ncol = 1L,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  xLab = NULL,
  facet = FALSE,
  includeLegend = TRUE,
  legendPosition = "right",
  y = NULL
)
}
\arguments{
\item{width}{Numeric, width of the plot in pixels,
700 by default.}

\item{height}{Numeric, height of the plot in pixels,
700 by default.}

\item{gg}{\code{\link[ggplot2]{ggplot}}}

\item{nrow}{single-length integer specifying the 
number of facet rows in the plot. (default = 1) 
Overwritten if \code{gg} is specified.}

\item{ncol}{single-length integer specifying the 
number of facet columns in the plot. (default = 1)
Overwritten if \code{gg} is specified.}

\item{title}{String with title for the plot.}

\item{subtitle}{String with subtitle.\cr
The subtitle is included at the top left of the plot,
below the title.}

\item{caption}{String with caption. \cr
The caption is included at the bottom right of the plot.
Please note that this might overlap with 
vertical or rotated x-axis labels.}

\item{xLab}{String with label for \code{xVar}.}

\item{facet}{Logical, if TRUE the plot
contains facets.}

\item{includeLegend}{Logical, if TRUE (by default)
a legend is available in the plot.}

\item{legendPosition}{String with position of the legend,
among: 'top'/'left'/'bottom'/'right', 'right' by default.}

\item{y}{Character vector or factor with elements in the y-axis,
or list of such vectors. If a list is provided, the maximum height
obtained across the different list elements is used.}
}
\value{
Numeric vector with width ('width')
and height ('height') of the plot
in pixels.
}
\description{
This function set sensitive defaults dimensions
for a plot in the package.
This includes:
\itemize{
\item{setting a default width for a figure to 
fit in a standard clinical data review report}
\item{increasing the figure height:}{
\itemize{
\item{for facetted plot, ensuring that each 
facet is relatively squared}
\item{if a caption, subtitle, title, title
for the x-axis are specified}
\item{if a legend is set at the bottom or the top
of the plot}
}
\item{increasing the figure width if a legend
is set at the left or the right of the plot}
}
}
}
\author{
Laure Cougnaud
}
