% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting-metadata.R
\name{knit_print.clinDataReviewMetadata}
\alias{knit_print.clinDataReviewMetadata}
\title{Print metadata file in the clinical data report}
\usage{
\method{knit_print}{clinDataReviewMetadata}(x, options = list(), ...)
}
\arguments{
\item{x}{List of two elements named \code{summaryInfo} and 
\code{datasetInfo}.}

\item{options}{List of extra options to be passed as chunk options. 
The option \code{dateReportRun} sets to true prints the date and time of the report creation.}

\item{...}{Extra arguments to be passed.}
}
\value{
Nothing. The tables are ready to be printed in Rmd.

html code to include metadata in a report
}
\description{
This function receives the metadata information from \code{\link{getMetadata}} and 
prints them in a format for an Rmd report.
In general, any list could be called as long as it is composed by two elements:
\itemize{
\item \code{summaryInfo}: an R object.
\item \code{datasetInfo}: a data.frame or a matrix.
}
The first (\code{summaryInfo}) is printed as \code{\link[knitr]{kable}} object 
and the second (\code{datasetInfo}) is printed as hide/show html button with 
the function \code{\link{collapseHtmlContent}}.
}
