% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dose2auc.R
\name{dose2auc}
\alias{dose2auc}
\title{Convert dose to expected AUCinf or AUCt for 1 compartment linear PK model}
\usage{
dose2auc(dose, CL, V, t_auc = NULL)
}
\arguments{
\item{dose}{dose amount}

\item{CL}{Clearance}

\item{V}{Volume of distribution}

\item{t_auc}{if AUC_t is desired, `t_auc` specifies time until which AUC_t is calculated}
}
\description{
Convert dose to expected AUCinf or AUCt for 1 compartment linear PK model
}
\examples{
dose2auc(dose = 1000, CL = 5, V = 50)
dose2auc(dose = 1000, CL = 5, V = 50, t_auc = c(12, 24, 48, 72))
}
