% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relative2absolute.R
\name{relative2absolute_bsa}
\alias{relative2absolute_bsa}
\title{Convert quantity expressed relative to BSA to absolute units}
\usage{
relative2absolute_bsa(quantity, bsa = NULL, ...)
}
\arguments{
\item{quantity}{quantity expressed in units /1.73m2}

\item{bsa}{ideal body weight in kg}

\item{...}{arguments passed on to `calc_bsa`, if bsa is NULL}
}
\value{
quantity expressed in absolute units
}
\description{
Often used for eGFR estimates
}
\examples{
relative2absolute_bsa(quantity = 60, bsa = 1.6)
relative2absolute_bsa(quantity = 60, weight = 14, height = 90, method = "dubois")
}
