% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knitPrintListPlots.R
\name{knitPrintListPlots}
\alias{knitPrintListPlots}
\title{Include a list of plots in a knitr document}
\usage{
knitPrintListPlots(
  plotsList,
  generalLabel = "plotsList",
  type = c("ggplot2", "plotly"),
  ...
)
}
\arguments{
\item{plotsList}{list of plots, e.g. \code{ggplot} objects
from the \code{ggplot2} package or from the \code{plotly} packages.}

\item{generalLabel}{general label for the chunks, used to build the \code{labels}.
The labels are constructed as '\code{generalLabel}[i]',
with i the plot number (from sequence spanning the length of \code{plotsList}).
Only use if \code{labels} is not specified.}

\item{type}{string with plot type: 'ggplot2' or 'plotly'}

\item{...}{
  Arguments passed on to \code{\link[=knitPrintListObjects]{knitPrintListObjects}}
  \describe{
    \item{\code{labels}}{Character vector with labels,
one for each chunk.\cr
This is also used to define file names
for plots exported in the document
(e.g. via \code{opts_chunk$set(dev = "png")}).}
    \item{\code{titles}}{Character vector with section titles,
one for each chunk.}
    \item{\code{titleLevel}}{Integer with level for section header,
1 for top-level section header.}
  }}
}
\value{
No returned value, a text is printed with chunk content
}
\description{
Each plot is included (internally) in a separated chunk,
so different chunk options can be set for each plot.\cr
For example, plots can be created with different
figure height or width (see examples).
}
\details{
This function should be called within a chunk
with the following option: \strong{\code{results = 'asis'}}.\cr
Note that a (one-level) list of \code{plotly} plots can 
also be included directly via
\code{htmltools::tagList(listPlots)}, but without the possibility to 
have different chunk option for each plot.
}
\examples{
\dontrun{

# Note: the following code should be included 
# within a chunk of a knitr (e.g. RMarkdown) document
# to include a list of figures in the Rmarkdown output
data(iris)

## Static plots

library(ggplot2)
plotsListStatic <- list(
	point = ggplot(data = cars, aes(x = speed, y = dist)) + geom_point(),
	line = ggplot(data = cars, aes(x = speed, y = dist)) + geom_line()
)
# with general label (used to name exported figure)
knitPrintListPlots(
	plotsList = plotsListStatic, 
	generalLabel = "scatter-cars"
)
# with label for each plot (used to name exported figure)
knitPrintListPlots(
	plotsList = plotsListStatic, 
	labels = names(plotsListStatic)
)
# with section header (header of level 1 in Markdown)
knitPrintListPlots(
	plotsList = plotsListStatic, 
	titles = names(plotsListStatic), 
	titleLevel = 3
)
# with caption for each figure
knitPrintListPlots(
	plotsList = plotsListStatic, 
	fig.cap = names(plotsListStatic)
)
	
# specify dimension for each figure
knitPrintListPlots(
	plotsList = plotsListStatic, 
	# first plot has width of 3, second of 6
	fig.width = c(3, 6), 
	# both plots have a height of 6
	fig.height = 6
)

## Interactive plots

library(plotly)
plotsListInteractive <- list(
	point = plot_ly(data = cars, x = ~speed, y = ~dist, type = "scatter", mode = "marker"),
	line = plot_ly(data = cars, x = ~speed, y = ~dist, type = "scatter", mode = "line")
)

# with titles
knitPrintListPlots(
	plotsList = plotsListInteractive, 
	type = "plotly", 
	titles = names(plotsListInteractive), 
	titleLevel = 3
)

}
}
\author{
Laure Cougnaud
}
