% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weekday.R
\name{weekday}
\alias{weekday}
\title{Construct a weekday vector}
\usage{
weekday(code = integer(), ..., encoding = "western")
}
\arguments{
\item{code}{\verb{[integer]}

Integer codes between \verb{[1, 7]} representing days of the week. The
interpretation of these values depends on \code{encoding}.}

\item{...}{These dots are for future extensions and must be empty.}

\item{encoding}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"western"}: Encode weekdays assuming \code{1 == Sunday} and \code{7 == Saturday}.
\item \code{"iso"}: Encode weekdays assuming \code{1 == Monday} and \code{7 == Sunday}. This
is in line with the ISO standard.
}}
}
\value{
A weekday vector.
}
\description{
A \code{weekday} is a simple type that represents a day of the week.

The most interesting thing about the weekday type is that it implements
\emph{circular arithmetic}, which makes determining the "next Monday" or
"previous Tuesday" from a sys-time or naive-time easy to compute.
See the examples.
}
\examples{
x <- as_naive_time(year_month_day(2019, 01, 05))

# This is a Saturday!
as_weekday(x)

# Adjust to the next Wednesday
wednesday <- weekday(clock_weekdays$wednesday)

# This returns the number of days until the next Wednesday using
# circular arithmetic
# "Wednesday - Saturday = 4 days until next Wednesday"
wednesday - as_weekday(x)

# Advance to the next Wednesday
x_next_wednesday <- x + (wednesday - as_weekday(x))

as_weekday(x_next_wednesday)

# What about the previous Tuesday?
tuesday <- weekday(clock_weekdays$tuesday)
x - (as_weekday(x) - tuesday)

# What about the next Saturday?
# With an additional condition that if today is a Saturday,
# then advance to the next one.
saturday <- weekday(clock_weekdays$saturday)
x + 1L + (saturday - as_weekday(x + 1L))

# You can supply an ISO coding for `code` as well, where 1 == Monday.
weekday(1:7, encoding = "western")
weekday(1:7, encoding = "iso")
}
