/*
 * Decompiled with CFR 0.152.
 */
package ppe.gui;

import java.awt.Container;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import nbl.utilj.GuiUtil;
import nbl.utilj.SysProp;
import ppe.AbstractParams;
import ppe.ParamHt;
import ppe.UtilPPE;
import ppe.ec2.ParamsEc2;
import ppe.gui.Ec2ParamEditorFrame;
import ppe.gui.PPEManager;

public class Ec2ParamEditor
implements ActionListener,
HyperlinkListener,
WindowStateListener {
    private String accountNumber;
    private String accessKeyID;
    private String secretAccessKey;
    private String rsaKeyName;
    private File rsaKeyPairFile;
    private PPEManager ppeManager;
    Ec2ParamEditorFrame edFrame;
    public boolean isRunning = true;
    String intro = "<html><body><p>Enter or modify Ec2 parameters. These parameters are <i>required</i> for launching and managing Ec2 instances.</p><p>These parameters will be stored in  <tt>" + ParamHt.getDefaultConfigFilePath() + "</tt>. " + "If you prefer, you can edit this file directly." + "<p>" + "Note that this file will contain your AWS 'Secret Key' " + "<i>en claire</i>, so it is important that it be secure. " + "It will be created with read and write permisson granted to " + "the owner only (0600 on unix systems) and we recommend that you " + "maintain restricted access to this file." + "</body></html>";
    String accountKeyText = "<html><body><p> The following three parameters can be obtained from your Amazon account <a href=\"https://aws-portal.amazon.com/gp/aws/developer/account/index.html?ie=UTF8&amp;action=access-key\">Security Credentials</a> page.</body></html>";
    String accountNumberText = "This is a twelve digit number located near the top right of the 'Security Credentials' page\n(among other places). You can enter it with or without the embedded dashes.";
    String accessKeyNotes = "The 'Access Key ID' and 'Secret Access Key' are in the  'Access Credentials' section of the\n'Access Keys' tab on your Amazon Security Credentials page.";
    String rsaNotes = "<html><body><p>Your key name is displayed in <a href=\"https://console.aws.amazon.com/ec2/home\">AWS Management Console</a> (EC2 tab, NETWORK & SECURITY -> Key Pair).</p><p>Ec2 instances are accessed using an RSA keypair, which is created and registered using theEC2/Keypair page of the AWS Management Console. (Note that Amazon does not keep a copyof the private key, only the public key.) The 'RSA key name' is the name you assigned to thiskeypair. The 'RSA keypair file' is the file that contains the keypair (downloaded from Amazonwhen you created the keypair).</p></body></html>";

    public Ec2ParamEditor(PPEManager ppeManager) {
        this.ppeManager = ppeManager;
        ParamHt ht = ppeManager.paramHt;
        if (ht == null) {
            return;
        }
        this.accountNumber = ht.getValue(ParamsEc2.ParamName.awsUserID.toString());
        this.accessKeyID = ht.getValue(ParamsEc2.ParamName.awsAccessKey.toString());
        this.secretAccessKey = ht.getValue(ParamsEc2.ParamName.awsSecretKey.toString());
        this.rsaKeyName = ht.getValue(ParamsEc2.ParamName.keyName.toString());
        String rsaKeyPairPath = ht.getValue(ParamsEc2.ParamName.rsaKeyPairFile.toString());
        if (rsaKeyPairPath != null) {
            this.rsaKeyPairFile = new File(rsaKeyPairPath);
        }
    }

    public void create() {
        this.edFrame = new Ec2ParamEditorFrame(this);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Ec2ParamEditor.this.edFrame.create();
                Ec2ParamEditor.this.edFrame.addWindowStateListener(Ec2ParamEditor.this);
                GuiUtil.centerOnScreen((Container)Ec2ParamEditor.this.edFrame);
                Ec2ParamEditor.this.initializeFields();
                Ec2ParamEditor.this.edFrame.setVisible(true);
            }
        });
    }

    void initializeFields() {
        this.edFrame.setAccountNumber(this.accountNumber);
        this.edFrame.setAccessKeyID(this.accessKeyID);
        this.edFrame.setSecretKey(this.secretAccessKey);
        this.edFrame.setRsaKeyName(this.rsaKeyName);
        if (this.rsaKeyPairFile != null) {
            this.edFrame.setRsaKeyPairFile(this.rsaKeyPairFile.getPath());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String com = e.getActionCommand();
        EntryControl ec = EntryControl.valueOf(com);
        switch (ec) {
            case chooseFile: {
                this.chooseFile();
                break;
            }
            case cancel: {
                this.edFrame.dispose();
                this.isRunning = false;
                break;
            }
            case ok: {
                if (!this.saveParams()) break;
                this.edFrame.dispose();
                this.ppeManager.updateParams();
                this.isRunning = false;
                break;
            }
            default: {
                this.handleParam(ec);
            }
        }
    }

    @Override
    public void windowStateChanged(WindowEvent e) {
        int s = e.getNewState();
        if (s == 201 || s == 202) {
            this.isRunning = false;
        }
    }

    private boolean handleParam(EntryControl ec) {
        try {
            switch (ec) {
                case accountNumber: {
                    this.parseAccountNumber();
                    break;
                }
                case accessKeyID: {
                    this.accessKeyID = this.edFrame.getAccessKeyID().trim();
                    this.checkString(this.accessKeyID, "Access Key ID");
                    break;
                }
                case secretAccessKey: {
                    this.secretAccessKey = this.edFrame.getSecretKey().trim();
                    break;
                }
                case rsaKeyName: {
                    this.rsaKeyName = this.edFrame.getRsaKeyName().trim();
                    this.checkString(this.rsaKeyName, "RSA key name");
                    break;
                }
                case rsaKeyPairFile: {
                    String pn = this.edFrame.getRsaKeyPairFile().trim();
                    File f = new File(pn);
                    if (AbstractParams.checkForReadFileAccess(f)) {
                        this.rsaKeyPairFile = f;
                        break;
                    }
                    this.rsaKeyPairFile = null;
                    return false;
                }
            }
            return true;
        }
        catch (BadParamException x) {
            GuiUtil.warning((String[])x.m, (String)x.title);
            return false;
        }
    }

    private void checkString(String s, String name) throws BadParamException {
        if (s == null || s.length() < 1) {
            throw new BadParamException(new String[]{name + " is blank."}, "Param error");
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        try {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                URL url = e.getURL();
                Desktop.getDesktop().browse(URI.create(url.toString()));
            }
        }
        catch (Exception xx) {
            GuiUtil.exceptionMessage((Throwable)xx);
        }
    }

    void parseAccountNumber() throws BadParamException {
        String s = this.edFrame.getAccountNumber().trim();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isDigit(c)) continue;
            b.append(c);
        }
        String ns = b.toString();
        if (ns.length() != 12) {
            throw new BadParamException(new String[]{s, "is not a valid account number. An account number must have twelve digits."}, "Invalid account number");
        }
        this.accountNumber = ns;
    }

    void chooseFile() {
        File f = GuiUtil.getFile((String)"Specify the RSA keypair file", (File)new File(SysProp.user_home.getVal()));
        if (f == null) {
            return;
        }
        if (f.exists() && !f.isDirectory()) {
            this.edFrame.setRsaKeyPairFile(f.getPath());
        } else {
            GuiUtil.warning((String[])new String[]{f.getPath() + " does not exist or is a directory."}, (String)"Improper file");
        }
    }

    boolean saveParams() {
        int nBad = 0;
        for (EntryControl ec : EntryControl.values()) {
            if (this.handleParam(ec)) continue;
            ++nBad;
        }
        if (nBad > 0) {
            return GuiUtil.answerIsYes((String[])new String[]{"There were errors in the params; exit without saving changes?"}, (String)"Quit now?");
        }
        this.writeParamsToFile();
        try {
            this.ppeManager.paramHt = new ParamHt(new String[0]);
            return true;
        }
        catch (Exception ifx) {
            GuiUtil.exceptionMessage((Throwable)ifx);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeParamsToFile() {
        BufferedWriter b = null;
        try {
            File backupFile = null;
            File f = new File(ParamHt.getDefaultConfigFilePath());
            if (f.exists() && !f.renameTo(backupFile = UtilPPE.getBackupFilename(f))) {
                GuiUtil.warning((String[])new String[]{"Unable to rename " + f.getPath() + "; changes were not saved."}, (String)"File rename error");
                return;
            }
            b = new BufferedWriter(new FileWriter(f));
            b.write(ParamsEc2.ParamName.awsUserID.toString() + "=" + this.accountNumber + "\n");
            b.write(ParamsEc2.ParamName.awsAccessKey.toString() + "=" + this.accessKeyID + "\n");
            b.write(ParamsEc2.ParamName.awsSecretKey.toString() + "=" + this.secretAccessKey + "\n");
            b.write(ParamsEc2.ParamName.keyName.toString() + "=" + this.rsaKeyName + "\n");
            b.write(ParamsEc2.ParamName.rsaKeyPairFile.toString() + "=" + this.rsaKeyPairFile.getPath());
            b.flush();
            GuiUtil.info((String[])new String[]{"Wrote Ec2 params to " + f.getPath(), backupFile != null ? "The old version was saved as " + backupFile.getPath() : ""}, (String)"Updated config file");
        }
        catch (IOException iox) {
            GuiUtil.exceptionMessage((Throwable)iox);
        }
        finally {
            if (b != null) {
                try {
                    b.flush();
                    b.close();
                }
                catch (IOException ox) {
                    GuiUtil.exceptionMessage((Throwable)ox);
                }
            }
        }
    }

    class BadParamException
    extends Exception {
        String[] m;
        String title;

        public BadParamException(String[] m, String title) {
            this.m = m;
            this.title = title;
        }
    }

    public static enum EntryControl {
        accountNumber,
        accessKeyID,
        secretAccessKey,
        rsaKeyName,
        rsaKeyPairFile,
        chooseFile,
        cancel,
        ok;

    }
}

