/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.cbui;

import com.amazonaws.cbui.AmazonFPSCBUIPipeline;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonFPSMultiUsePipeline
extends AmazonFPSCBUIPipeline {
    public AmazonFPSMultiUsePipeline(String accessKey, String secretKey) {
        super("MultiUse", accessKey, secretKey);
    }

    public void setMandatoryParameters(String callerReference, String returnUrl, String globalAmountLimit) {
        this.addParameter("callerReference", callerReference);
        this.addParameter("returnURL", returnUrl);
        this.addParameter("globalAmountLimit", globalAmountLimit);
    }

    public void setUsageLimit1(String limitType, String limitValue, String limitPeriod) {
        this.addParameter("usageLimitType1", limitType);
        this.addParameter("usageLimitValue1", limitValue);
        if (limitPeriod != null) {
            this.addParameter("usageLimitPeriod1", limitPeriod);
        }
    }

    public void setUsageLimit2(String limitType, String limitValue, String limitPeriod) {
        this.addParameter("usageLimitType1", limitType);
        this.addParameter("usageLimitValue1", limitValue);
        if (limitPeriod != null) {
            this.addParameter("usageLimitPeriod1", limitPeriod);
        }
    }

    public void setRecipientTokenList(boolean isRecipientCobranding, List<String> tokens) {
        this.addParameter("isRecipientCobranding", isRecipientCobranding ? "True" : "False");
        if (tokens == null || tokens.isEmpty()) {
            return;
        }
        StringBuilder tokenListBuilder = new StringBuilder();
        for (String token : tokens) {
            tokenListBuilder.append(token);
            tokenListBuilder.append(",");
        }
        String tokenList = tokenListBuilder.toString();
        tokenList = tokenList.substring(0, tokenList.length() - 1);
        this.addParameter("recipientTokenList", tokenList);
    }

    @Override
    protected void validateParameters(Map<String, String> parameters) {
        if (!parameters.containsKey("globalAmountLimit")) {
            throw new RuntimeException("globalAmountLimit is missing in parameters.");
        }
        if (parameters.containsKey("isRecipientCobranding") && !parameters.containsKey("recipientTokenList")) {
            throw new RuntimeException("recipientTokenList is missing in parameters.");
        }
        if (parameters.containsKey("usageLimitType1") && !parameters.containsKey("usageLimitValue1")) {
            throw new RuntimeException("usageLimitValue1 is missing in parameters.");
        }
        if (parameters.containsKey("usageLimitType2") && !parameters.containsKey("usageLimitValue2")) {
            throw new RuntimeException("usageLimitValue2 is missing in parameters.");
        }
    }
}

