% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signedrank-perm.R
\name{cluswilcox.test.signedrank.permutation}
\alias{cluswilcox.test.signedrank.permutation}
\title{The Wilcoxon Signed Rank Test for Clustered Data}
\usage{
\method{cluswilcox.test}{signedrank.permutation}(x, cluster, alternative, mu,
  n.rep = 500, DNAME = NULL, METHOD = NULL)
}
\arguments{
\item{x}{numeric vector of data values. Non-finite (e.g.,
infinite or missing) values will be omitted.}

\item{cluster}{numeric or charater vector, the id of clusters.
 If not specified, each observation will
be assigned a distinct cluster, i.e., no cluster in the data.}

\item{alternative}{a character string specifying the
alternative hypothesis, must be one of "two.sided" (default),
 "greater" or "less". You can specify just the initial letter.}

\item{mu}{null value of the hypothesis}

\item{n.rep}{number of samples generated for permutation test.}

\item{DNAME}{a character string, inheritated from
\code{cluswilcox.test.formula}, for result output.}

\item{METHOD}{a character string, inheritated from
\code{cluswilcox.test.formula}, for result output.}
}
\value{
a list with class "\code{ctest}" containing
the following components:
\item{rstatistic}{the value of the signed rank statistic
 with a name describing it.}
\item{vrstatistic}{Variance of \code{rstatistic}.}
\item{statistic}{the value of the test statistic.}
\item{p.value}{the p-value for the test.}
\item{n}{Total number of observations.}
\item{cn}{Total number of clusters.}
\item{data.name}{a character string giving the names of the data.}
\item{method}{the type of test applied.}
\item{adjusted}{indicator of whether adjusted signed rank statistic is used.}
}
\description{
Performs one-sample Wilcoxon test on vectors of data using
large sample.
}
\note{
This function is able to deal with data with
clusterentitical or variable cluster size. When the data
is unbalanced, adjusted signed rank statistic is used.
Ties are dropped in the test.
}
\examples{
data(crsd)
cluswilcox.test(z, cluster = id, data = crsd, permutation = TRUE)
data(crsdUnb)
cluswilcox.test(z, cluster = id, data = crsdUnb, permutation = TRUE)
}
\author{
Yujing Jiang
}
\references{
Bernard Rosner, Robert J. Glynn, Mei-Ling Ting Lee(2006)
\emph{The Wilcoxon Signed Rank Test for Paired Comparisons of
 Clustered Data.} Biometrics, \bold{62}, 185-192.
}

