% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoring_functions_Rcpp.R
\name{FOMD}
\alias{FOMD}
\title{FOMD (Fraction Over Median Degree)}
\usage{
FOMD(g, com, edgelist = NULL)
}
\arguments{
\item{g}{Graph to be analyzed (as an \code{igraph} object). If the edges have a "weight"
attribute, those will be used as weights.}

\item{com}{Community membership integer vector. Each element corresponds to a vertex.}

\item{edgelist}{alternatively, the edgelist of the graph, as a matrix where the
first two columns to the vertices and the third is the weight of each edge.}
}
\value{
Numeric vector with the FOMD of each community.
}
\description{
Given a weighted graph and a partition into communities, returns the fraction
of nodes of each community whose internal degree (i.e. the degree accounting
only intra-community edges) is greater than the median degree of the whole
graph.
}
\examples{
data(karate, package="igraphdata")
FOMD(karate, membership(cluster_louvain(karate)))
}
\seealso{
Other cluster scoring functions: 
\code{\link{average_degree}()},
\code{\link{average_odf}()},
\code{\link{conductance}()},
\code{\link{coverage}()},
\code{\link{cut_ratio}()},
\code{\link{density_ratio}()},
\code{\link{edges_inside}()},
\code{\link{expansion}()},
\code{\link{internal_density}()},
\code{\link{max_odf}()},
\code{\link{normalized_cut}()},
\code{\link{weighted_clustering_coefficient}()},
\code{\link{weighted_transitivity}()}
}
\concept{cluster scoring functions}
