% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrected_mutual_information.R
\name{reduced_mutual_information}
\alias{reduced_mutual_information}
\title{Reduced Mutual Information}
\usage{
reduced_mutual_information(
  c1,
  c2,
  base = exp(1),
  normalized = FALSE,
  method = "approximation2",
  warning = TRUE
)
}
\arguments{
\item{c1, c2}{membership vectors}

\item{base}{base of the logarithms used in the calculations. Changing it only scales the final value. By default set to e=exp(1).}

\item{normalized}{If true, computes the normalized version of the corrected mutual information.}

\item{method}{Can be "hybrid" (default, combines Monte Carlo with analytical formula), "monte_carlo", 
approximation1" (appropriate for partitions into many very small clusters), 
or "approximation2" (for partitions into few larger clusters).}

\item{warning}{set to false to ignore the warning.}
}
\value{
The value of Newman's RMI (a scalar).
}
\description{
Computes the Newman's Reduced Mutual Information (RMI) as defined in 
\insertCite{corrected_MI_Newman2020}{clustAnalytics}.
}
\details{
The implementation is based on equations 23 (25 for the normalized case) and 29 in \insertCite{corrected_MI_Newman2020}{clustAnalytics}.
The evaluations of the \eqn{\Gamma} functions can get too large and cause overflow 
issues in the intermediate steps, so the following term of equation 29:
\deqn{\frac{1}{2} \log \frac{\Gamma(\mu R) \Gamma(\nu S)} {(\Gamma(\nu)\Gamma(R))^S (\Gamma(\mu)\Gamma(S))^R } }
is rewritten as 
\deqn{\frac{1}{2} (\log\Gamma(\mu R) + \log\Gamma(\nu S) - S\log(\Gamma(\nu) - S\log(\Gamma(R) - R\log\Gamma(\mu) - R\log\Gamma(R)  )},
and then the function \link[base]{lgamma} is used instead of \link[base]{gamma}.
}
\section{References}{

\insertRef{corrected_MI_Newman2020}{clustAnalytics}
}

