% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choosem.R
\name{choosem}
\alias{choosem}
\title{Graphical investigation for the number of datasets generated by multiple imputation}
\usage{
choosem(output, graph = TRUE)
}
\arguments{
\item{output}{an output from the clusterMI function}

\item{graph}{a boolean indicating if a graphic is plotted}
}
\value{
A list of two objects
  \item{part}{\code{m}-columns matrix that contains in column p the consensus partition using only the p first imputed datasets}
  \item{rand}{a \code{m}-1 vector given the rand index between the \code{m} successive consensus partitions}
}
\description{
For an object generated by the function \code{clusterMI}, the \code{choosem} function browses the sequence of the contributory partitions and computes the consensus partition at each step. Then, the rand index between successive consensus partitions is plotted.
}
\details{
The number of imputed datasets (\code{m}) should be sufficiently large to improve the partition accuracy.
The \code{choosem} function can be used to check if this number is suitable.
This function computes the consensus partition by considering only the first imputed datasets.
By this way, a sequence of \code{m} consensus partitions is obtained.
Then, the rand index between successive partitions is computed and reported in a graph.
The rand index measures the proximity between two partitions.
If the rand index between the last consensus partitions of the sequence reaches its maximum values (1),
then it means last imputed dataset does not modify the consensus partition.
Consequently, the number of imputed datasets can be considered as sufficiently large.
}
\examples{
data(wine)

set.seed(123456)
ref <- wine$cult
nb.clust <- 3
wine.na <- wine
wine.na$cult <- NULL
wine.na <- as.matrix(wine.na)
wine.na[sample(seq(length(wine.na)), size = ceiling(length(wine.na)/3))] <- NA

#imputation
m <- 5 # number of imputed data sets. Should be larger in practice
res.imp <- imputedata(data.na = wine.na, nb.clust = nb.clust, m = m)

#pooling
res.pool <- clusterMI(res.imp, instability = FALSE)

res.choosem <- choosem(res.pool)
}
\references{
Audigier, V. and Niang, N., Clustering with missing data: which equivalent for Rubin's rules? Advances in Data Analysis and Classification <doi:10.1007/s11634-022-00519-1>, 2022.
}
\seealso{
\code{\link{clusterMI}}, \code{\link{imputedata}}
}
