% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binCalcICC.R
\name{binCalcICC}
\alias{binCalcICC}
\title{BinCalcICC: calculate ICC values for data from CRTs with binary outcomes.}
\usage{
binCalcICC(
  data = NULL,
  method = c("aov", "aovs", "keq", "kpr", "keqs", "kprs", "stab", "ub", "fc", "mak",
    "peq", "pgp", "ppr", "rm", "lin", "sim"),
  ci.type = c("aov", "wal", "fc", "peq", "rm"),
  alpha = 0.05,
  kappa = 0.45,
  nAGQ = 1,
  sim.min = 1,
  sim.max = 100,
  nsim = 1000
)
}
\arguments{
\item{data}{A dataframe of the sort generated
by \code{cps.binary()} or \code{cps.ma.binary()}; can be generate by
using \code{all.sim.data = TRUE}.}

\item{method}{The method to be used to compute ICC. A single or multiple
methods can be used at a time. By default, all 16 methods will be used. See
Details for more information.}

\item{ci.type}{The type of confidence interval to be computed. By default all 5
types will be reported. See Details for more information.}

\item{alpha}{The significance level to be used while computing the confidence
interval. Default value is 0.05.}

\item{kappa}{Value of Kappa to be used in computing Stabilized ICC when the
method stab is chosen. Default value is 0.45.}

\item{nAGQ}{An integer, as in glmer function of package lme4, denoting the
number of points per axis for evaluating the adaptive Gauss-Hermite approximation
to the log-likelihood. Used when the method lin is chosen. Default value is 1.}

\item{sim.min}{Optional, integer. The number of the first simulation for which ICC will be calculated.
Default is 1.}

\item{sim.max}{Optional, integer. The number of the last simulation for which ICC
will be calculated. Default is \code{nsim}.}

\item{nsim}{Number of Monte Carlo replicates used in ICC computation method.
\code{sim}. Default is 1000.}
}
\value{
A list with the following components:
\describe{
  \item{estimate}{A dataframe containing the name of methods used and
  corresponding estimates of Intracluster Correlation coefficients}
  \item{confidence.intervals}{A dataframe containing names of
  confidence interval types and corresponding estimated confidence
  intervals}	}
}
\description{
BinCalcICC: calculate ICC values for data from CRTs with binary outcomes.
}
\examples{
\dontrun{
bin.ma.rct.unbal <- cps.ma.binary(nsim = 3,
                            nsubjects = list(rep(200, times=15),
                            rep(150, times=15),
                            rep(170, times=15)),
                            narms = 3,
                            nclusters = 15,
                            probs = c(0.15, 0.23, 0.22),
                            sigma_b_sq = c(0.1, 0.1, 0.1),
                            alpha = 0.05, allSimData = TRUE,
                            seed = 123, cores="all")

binCalcICC(data = bin.ma.rct.unbal, nsim = 1000)
}

\dontrun{ 
binary.sim = cps.binary(nsim = 100, nsubjects = 20,
  nclusters = 10, p1 = 0.8,
  p2 = 0.5, sigma_b_sq = 1,
  sigma_b_sq2 = 1.2, alpha = 0.05,
  method = 'glmm', allSimData = TRUE)

binCalcICC(data = binary.sim, nsim = 1000)
}


}
\author{
Alexandria C. Sakrejda (\email{acbro0@umass.edu}) and Ken Kleinman (\email{ken.kleinman@gmail.com})
}
