% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cps.ma.binary.R
\name{cps.ma.binary}
\alias{cps.ma.binary}
\title{Simulation-based power estimation for binary outcome multi-arm
cluster-randomized trials.}
\usage{
cps.ma.binary(
  nsim = 1000,
  nsubjects = NULL,
  narms = NULL,
  nclusters = NULL,
  probs = NULL,
  sigma_b_sq = NULL,
  alpha = 0.05,
  quiet = FALSE,
  method = "glmm",
  multi_p_method = "bonferroni",
  allSimData = FALSE,
  seed = NULL,
  cores = NA,
  tdist = FALSE,
  poorFitOverride = FALSE,
  lowPowerOverride = FALSE,
  timelimitOverride = TRUE,
  nofit = FALSE,
  optmethod = "Nelder-Mead",
  return.all.models = FALSE
)
}
\arguments{
\item{nsim}{Number of datasets to simulate; accepts integer (required).}

\item{nsubjects}{Number of subjects per cluster (required); accepts an
integer if all are equal and \code{narms} and \code{nclusters} are provided.
Alternately, the user can supply a list with one entry per arm if the
cluster sizes are the same within the arm, or, if they are not the same
within the arms, the user can supply a list of vectors where each vector
represents an arm and each entry in the vector is the number of subjects
per cluster.}

\item{narms}{Integer value representing the number of trial arms.}

\item{nclusters}{An integer or vector of integers representing the number
of clusters in each arm.}

\item{probs}{Expected absolute treatment effect probabilities for each arm;
accepts a scalar or a vector of length \code{narms} (required).}

\item{sigma_b_sq}{Between-cluster variance; accepts a vector of length
\code{narms} (required).}

\item{alpha}{Significance level; default = 0.05.}

\item{quiet}{When set to FALSE, displays simulation progress and estimated completion time; default is FALSE.}

\item{method}{Analytical method, either Generalized Linear Mixed Effects
Model (GLMM) or Generalized Estimating Equation (GEE). Accepts c('glmm',
'gee') (required); default = 'glmm'.}

\item{multi_p_method}{A string indicating the method to use for adjusting
p-values for multiple comparisons. Choose one of "holm", "hochberg",
"hommel", "bonferroni", "BH", "BY", "fdr", "none". The default is
"bonferroni". See \code{?p.adjust} for additional details.}

\item{allSimData}{Option to output list of all simulated datasets;
default = FALSE.}

\item{seed}{Option to set.seed. Default is NULL.}

\item{cores}{String ("all"), NA, or scalar value indicating the number of cores
to be used for parallel computing. Default = NA (no parallel computing).}

\item{tdist}{Logical value indicating whether simulated data should be
drawn from a t-distribution rather than the normal distribution.
Default = FALSE.}

\item{poorFitOverride}{Option to override \code{stop()} if more than 25\% of fits fail to converge or
power<0.5 after 50 iterations; default = FALSE.}

\item{lowPowerOverride}{Option to override \code{stop()} if the power
is less than 0.5 after the first 50 simulations and every ten simulations
thereafter. On function execution stop, the actual power is printed in the
stop message. Default = FALSE. When TRUE, this check is ignored and the
calculated power is returned regardless of value.}

\item{timelimitOverride}{Logical. When FALSE, stops execution if the estimated
completion time is more than 2 minutes. Defaults to TRUE.}

\item{nofit}{Option to skip model fitting and analysis and return the
simulated data.
Defaults to \code{FALSE}.}

\item{optmethod}{User-specified optimizer method. Accepts \code{bobyqa},
\code{Nelder_Mead} (default), and optimizers wrapped in the \code{optimx} package.}

\item{return.all.models}{Logical; Returns all of the fitted models and the
simulated data.
Defaults to FALSE.}
}
\value{
A list with the following components:
\describe{
  \item{power}{Data frame with columns "power" (Estimated statistical power),
               "lower.95.ci" (Lower 95\% confidence interval bound),
               "upper.95.ci" (Upper 95\% confidence interval bound).}
  \item{model.estimates}{Data frame with columns corresponding
  to each arm with descriptive suffixes as follows:
                  ".Estimate" (Estimate of treatment effect for a given
                  simulation),
                  "Std.Err" (Standard error for treatment effect estimate),
                  ".zval" (for GLMM) | ".wald" (for GEE), and
                  ".pval" (the p-value estimate).}
  \item{overall.power}{Table of F-test (when method="glmm") or chi^{2}
  (when method="gee") significance test results.}
  \item{overall.power.summary}{Summary overall power of treatment model
  compared to the null model.}
  \item{sim.data}{Produced when allSimData==TRUE. List of \code{nsim}
  data frames, each containing:
                  "y" (simulated response value),
                  "trt" (indicator for treatment group or arm), and
                  "clust" (indicator for cluster).}
  \item{model.fit.warning.percent}{Character string containing the percent
  of \code{nsim} in which the glmm fit was singular or failed to converge,
  produced only when method = "glmm" & allSimData = FALSE.
  }
  \item{model.fit.warning.incidence}{Vector of length \code{nsim} denoting
  whether or not a simulation glmm fit triggered a "singular fit" or
  "non-convergence" error, produced only when method = "glmm" &
  allSimData=TRUE.
  }
  }
If \code{nofit = T}, a data frame of the simulated data sets, containing:
\itemize{
  \item "arm" (Indicator for treatment arm)
  \item "cluster" (Indicator for cluster)
  \item "y1" ... "yn" (Simulated response value for each of the \code{nsim} data sets).
  }
}
\description{
This function uses iterative simulations to determine
approximate power for multi-arm cluster-randomized controlled trials with
binary outcomes of interest. Users can modify a variety of parameters to
suit the simulations to their desired experimental situation.
This function validates the user's input and passes the necessary
arguments to an internal function, which performs the simulations.
This function returns the summary power values for each treatment arm.
}
\details{
Users must specify the desired number of simulations, number of subjects per
cluster, number of clusters per treatment arm, group probabilities, and the
between-cluster variance. Significance level, analytic method, progress
updates, poor/singular fit override, and whether or not to return the
simulated data may also be specified. The internal function can be called
directly by the user to return the fitted models rather than the power
summaries (see \code{?cps.ma.normal.internal} for details).

Because the model for binary outcomes may be slower to fit than those for
other distributions, this function may be slower than its normal or
count-distributed counterparts. Users can spread the simulated data
generation and model fitting tasks across multiple cores using the
\code{cores} argument. Users should expect that parallel computing may make
model fitting faster than using a single core for more complicated models.
For simpler models, users may prefer to use single thread computing
(\code{cores}=1), as the processes involved in allocating memory and
copying data across cores also may take some time. For time-savings,
this function stops execution early if estimated power < 0.5 or more
than 25\% of models produce a singular fit or non-convergence warning
message, unless \code{poorFitOverride = TRUE}.

Non-convergent models are not included in the calculation of exact confidence
intervals.
}
\section{Testing details}{

This function has been verified, where possible, against reference values from the NIH's GRT
Sample Size Calculator, PASS11, \code{CRTsize::n4prop}, \code{clusterPower::cps.binary}, and
\code{clusterPower::cpa.binary}.
}

\examples{
\dontrun{
bin.ma.rct.unbal <- cps.ma.binary(nsim = 12,
                            nsubjects = list(rep(20, times=15),
                            rep(15, times=15),
                            rep(17, times=15)),
                            narms = 3,
                            nclusters = 15,
                            probs = c(0.35, 0.43, 0.50),
                            sigma_b_sq = c(0.1, 0.1, 0.1),
                            alpha = 0.05, allSimData = TRUE,
                            seed = 123, cores="all")

bin.ma.rct.bal <- cps.ma.binary(nsim = 100, nsubjects = 50, narms=3,
                            nclusters=8,
                            probs = c(0.35, 0.4, 0.5),
                            sigma_b_sq = 0.1, alpha = 0.05,
                            quiet = FALSE, method = 'glmm',
                            allSimData = FALSE,
                            multi_p_method="none",
                            seed = 123, cores="all",
                            poorFitOverride = FALSE)
}
}
\author{
Alexandria C. Sakrejda (\email{acbro0@umass.edu}), Alexander R. Bogdan, and Ken Kleinman (\email{ken.kleinman@gmail.com})
}
