% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlaps.R
\name{clustermole_overlaps}
\alias{clustermole_overlaps}
\title{Cell types based on overlap of marker genes}
\usage{
clustermole_overlaps(genes, species)
}
\arguments{
\item{genes}{A vector of genes.}

\item{species}{Species: \code{hs} for human or \code{mm} for mouse.}
}
\value{
A data frame of enrichment results with hypergeometric test p-values.
}
\description{
Perform overrepresentation analysis for a set of genes compared to all cell type signatures.
}
\examples{
my_genes <- c("CD2", "CD3D", "CD3E", "CD3G", "TRAC", "TRBC2", "LTB")
my_overlaps <- clustermole_overlaps(genes = my_genes, species = "hs")
head(my_overlaps)
}
