% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qsys_ssh.r
\name{SSH}
\alias{SSH}
\title{SSH scheduler functions}
\description{
Derives from QSys to provide SSH-specific functions
}
\keyword{internal}
\section{Super class}{
\code{\link[clustermq:QSys]{clustermq::QSys}} -> \code{SSH}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SSH$new()}}
\item \href{#method-submit_jobs}{\code{SSH$submit_jobs()}}
\item \href{#method-cleanup}{\code{SSH$cleanup()}}
\item \href{#method-finalize}{\code{SSH$finalize()}}
\item \href{#method-clone}{\code{SSH$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="clustermq" data-topic="QSys" data-id="receive_data">}\href{../../clustermq/html/QSys.html#method-receive_data}{\code{clustermq::QSys$receive_data()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="clustermq" data-topic="QSys" data-id="send_call">}\href{../../clustermq/html/QSys.html#method-send_call}{\code{clustermq::QSys$send_call()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="clustermq" data-topic="QSys" data-id="send_common_data">}\href{../../clustermq/html/QSys.html#method-send_common_data}{\code{clustermq::QSys$send_common_data()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="clustermq" data-topic="QSys" data-id="send_job_data">}\href{../../clustermq/html/QSys.html#method-send_job_data}{\code{clustermq::QSys$send_job_data()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="clustermq" data-topic="QSys" data-id="send_shutdown_worker">}\href{../../clustermq/html/QSys.html#method-send_shutdown_worker}{\code{clustermq::QSys$send_shutdown_worker()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="clustermq" data-topic="QSys" data-id="send_wait">}\href{../../clustermq/html/QSys.html#method-send_wait}{\code{clustermq::QSys$send_wait()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="clustermq" data-topic="QSys" data-id="set_common_data">}\href{../../clustermq/html/QSys.html#method-set_common_data}{\code{clustermq::QSys$set_common_data()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SSH$new(
  data,
  ...,
  ssh_host = getOption("clustermq.ssh.host"),
  ssh_log = getOption("clustermq.ssh.log"),
  template = getOption("clustermq.template", "SSH")
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-submit_jobs"></a>}}
\if{latex}{\out{\hypertarget{method-submit_jobs}{}}}
\subsection{Method \code{submit_jobs()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SSH$submit_jobs(..., verbose = TRUE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cleanup"></a>}}
\if{latex}{\out{\hypertarget{method-cleanup}{}}}
\subsection{Method \code{cleanup()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SSH$cleanup(quiet = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-finalize}{}}}
\subsection{Method \code{finalize()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SSH$finalize(quiet = self$workers_running == 0)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SSH$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
