% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusternor.R
\name{Kmedoids}
\alias{Kmedoids}
\title{Perform k-medoids clustering on a data matrix.
After initialization the k-medoids algorithm partitions data by testing which
 data member of a cluster Ci may make a better candidate as medoid (centroid)
 by reducing the sum of distance (usually taxi), then running a reclustering
 step with updated medoids.}
\usage{
Kmedoids(data, centers, nrow = -1, ncol = -1,
  iter.max = .Machine$integer.max, nthread = -1, init = c("forgy"),
  tolerance = 1e-06, dist.type = c("taxi", "eucl", "cos"))
}
\arguments{
\item{data}{Data file name on disk or In memory data matrix}

\item{centers}{The number of centers (i.e., k)}

\item{nrow}{The number of samples in the dataset}

\item{ncol}{The number of features in the dataset}

\item{iter.max}{The maximum number of iteration of k-means to perform}

\item{nthread}{The number of parallel threads to run}

\item{init}{The type of initialization to use c("forgy")}

\item{tolerance}{The convergence tolerance}

\item{dist.type}{What dissimilarity metric to use}
}
\value{
A list containing the attributes of the output of kmedoids.
 cluster: A vector of integers (from 1:\strong{k}) indicating the cluster to
         which each point is allocated.
 centers: A matrix of cluster centres.
 size: The number of points in each cluster.
 iter: The number of (outer) iterations.
}
\description{
Perform k-medoids clustering on a data matrix.
After initialization the k-medoids algorithm partitions data by testing which
 data member of a cluster Ci may make a better candidate as medoid (centroid)
 by reducing the sum of distance (usually taxi), then running a reclustering
 step with updated medoids.
}
\examples{
iris.mat <- as.matrix(iris[,1:4])
k <- length(unique(iris[, dim(iris)[2]])) # Number of unique classes
km <- Kmedoids(iris.mat, k)

}
\author{
Disa Mhembere <disa@cs.jhu.edu>
}
