% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cholesky.R
\name{choleskymatrix}
\alias{choleskymatrix}
\title{Cholesky Decomposition}
\usage{
choleskymatrix(m)
}
\arguments{
\item{m}{a matrix}
}
\value{
the matrix L
}
\description{
Decompose a matrix into the Cholesky
}
\details{
\code{choleskymatrix} decomposes the matrix \code{m} into the LU
decomposition, such that m == L %*% L*.
}
\examples{
(A <- matrix(c(5, 1, 2, 1, 9, 3, 2, 3, 7), 3))
(L <- choleskymatrix(A))
t(L) \%*\% L

}
\seealso{
Other linear: \code{\link{detmatrix}}, \code{\link{gdls}},
  \code{\link{invmatrix}}, \code{\link{iterativematrix}},
  \code{\link{lumatrix}}, \code{\link{refmatrix}},
  \code{\link{rowops}}, \code{\link{tridiagmatrix}},
  \code{\link{vecnorm}}
}

