% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simp.R
\name{simp}
\alias{simp}
\title{Simpson's rule}
\usage{
simp(f, a, b, m = 100)
}
\arguments{
\item{f}{function to integrate}

\item{a}{the a-bound of integration}

\item{b}{the b-bound of integration}

\item{m}{the number of subintervals to calculate}
}
\value{
the value of the integral
}
\description{
Use Simpson's rule to integrate a function
}
\details{
The \code{simp} function uses Simpson's rule to calculate the
integral of the function \code{f} over the interval from \code{a}
to \code{b}.  The parameter \code{m} sets the number of intervals
to use when evaluating.  Additional options are passed to the
function \code{f} when evaluating.
}
\examples{
f <- function(x) { sin(x)^2 + cos(x)^2 }
simp(f, -pi, pi, m = 10)
simp(f, -pi, pi, m = 100)
simp(f, -pi, pi, m = 1000)

}
\seealso{
Other integration: \code{\link{adaptint}},
  \code{\link{gaussint}}, \code{\link{giniquintile}},
  \code{\link{mcint}}, \code{\link{midpt}},
  \code{\link{revolution-solid}}, \code{\link{romberg}},
  \code{\link{simp38}}, \code{\link{trap}}

Other newton-cotes: \code{\link{adaptint}},
  \code{\link{giniquintile}}, \code{\link{midpt}},
  \code{\link{romberg}}, \code{\link{simp38}},
  \code{\link{trap}}
}

