% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmtest.R
\name{cmtest}
\alias{cmtest}
\alias{cmtest.tobit}
\alias{cmtest.censReg}
\alias{cmtest.glm}
\title{Conditional moments test}
\usage{
cmtest(
  x,
  test = c("normality", "reset", "heterosc", "skewness", "kurtosis"),
  powers = 2:3,
  heter_cov = NULL,
  OPG = FALSE
)

\method{cmtest}{tobit}(
  x,
  test = c("normality", "reset", "heterosc", "skewness", "kurtosis"),
  powers = 2:3,
  heter_cov = NULL,
  OPG = FALSE
)

\method{cmtest}{censReg}(
  x,
  test = c("normality", "reset", "heterosc", "skewness", "kurtosis"),
  powers = 2:3,
  heter_cov = NULL,
  OPG = FALSE
)

\method{cmtest}{glm}(
  x,
  test = c("normality", "reset", "heterosc", "skewness", "kurtosis"),
  powers = 2:3,
  heter_cov = NULL,
  OPG = FALSE
)
}
\arguments{
\item{x}{a fitted model, currently a tobit model either fitted by
\code{AER::tobit} or \code{censReg::censReg} or a probit model fitted by
\code{glm} with \code{family = binomial(link = 'probit')},}

\item{test}{the kind of test to be performed, either a normality
test (or separately a test that the skewness or kurtosis
coefficients are 0 and 3), a heteroscedasticity test or a reset
test,}

\item{powers}{the powers of the fitted values that should be used
in the reset test,}

\item{heter_cov}{a one side formula that indicates the covariates
that should be used for the heteroscedasticity test (by default
all the covariates used in the regression are used),}

\item{OPG}{a boolean, if \code{FALSE} (the default), the analytic
derivatives are used, otherwise the outer product of the
gradient formula is used}
}
\value{
a list with class \code{'htest'} containing the following components:
\itemize{
\item data.mane: a character string describing the fitted model
\item statistic: the value of the test statistic
\item parameter: degrees of freedom
\item p.value: the p.value of the test
\item method: a character indicating what type of test is performed
}
}
\description{
Conditional moments tests for maximum likelihood estimators consist
on adding to the matrix of individual contributions to the score
moments conditions and then test the hypothesis that the expected
value of the vector of augmented scores is zero. It is particularly
convenient for the probit and the tobit model to test for
functional form, omitted variables, heteroscedasticity and normaliy.
}
\examples{
# replication of Wells (2003) and Pagan and Vella (1989) using Fair's data
library("AER")
data("Affairs", package = "AER")
z <- tobit(affairs ~ gender + age + yearsmarried + children + religiousness +
                     education + occupation + rating, data = Affairs)
cmtest(z, test = "normality")
cmtest(z, test = "skewness", OPG = TRUE)
cmtest(z, test = "kurtosis", OPG = TRUE)
cmtest(z, test = "reset", powers = 2, OPG = TRUE)
cmtest(z, test = "reset", powers = 3, OPG = TRUE)
cmtest(z, test = "heterosc", OPG = TRUE, heter_cov = ~ gender)
}
\references{
\insertRef{NEWE:85}{cmtest}

\insertRef{PAGA:VELL:89}{cmtest}

\insertRef{TAUC:85}{cmtest}

\insertRef{WELL:03}{cmtest}
}
\author{
Yves Croissant
}
\keyword{htest}
