% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumstat_sfs.R
\name{sumstat_sfs}
\alias{sumstat_sfs}
\title{Summary Statistic: Site Frequency Spectrum}
\usage{
sumstat_sfs(name = "sfs", population = "all", transformation = identity)
}
\arguments{
\item{name}{The name of the summary statistic. When simulating a model,
the value of the statistics are written to an entry of the returned list
with this name. Summary statistic names must be unique in a model.}

\item{population}{The population for which the statistic is calculated.
Can also be "all" to calculate it from all populations.}

\item{transformation}{An optional function for transforming the results
of the statistic. If specified, the results of the transformation are
returned instead of the original values.}
}
\description{
The Site Frequency Spectrum (SFS) counts how many
SNPs are in a sample according to their number of
derived alleles.
}
\examples{
model <- coal_model(20, 500) +
  feat_mutation(2) +
  sumstat_sfs()
stats <- simulate(model)
barplot(stats$sfs)
}
\seealso{
To create a demographic model: \code{\link{coal_model}}

To calculate this statistic from data: \code{\link{calc_sumstats_from_data}}

Other summary statistics: \code{\link{sumstat_dna}},
  \code{\link{sumstat_file}},
  \code{\link{sumstat_four_gamete}},
  \code{\link{sumstat_ihh}}, \code{\link{sumstat_jsfs}},
  \code{\link{sumstat_mcmf}},
  \code{\link{sumstat_nucleotide_div}},
  \code{\link{sumstat_omega}},
  \code{\link{sumstat_seg_sites}},
  \code{\link{sumstat_tajimas_d}},
  \code{\link{sumstat_trees}}
}

