% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_selection.R
\name{feat_selection}
\alias{feat_selection}
\title{Feature: Selection}
\usage{
feat_selection(
  strength_AA = 0,
  strength_Aa = 0,
  strength_aa = 0,
  strength_A = NULL,
  population = "all",
  time,
  start = TRUE,
  start_frequency = 5e-04,
  Ne = 10000,
  position = 0.5,
  force_keep = TRUE,
  locus_group = "all"
)
}
\arguments{
\item{strength_AA}{The selection strength for the selected homozygote.
The parameter is valid for the chosen population and the time further
past-wards from either time 0 on if \code{start = TRUE}, or from \code{time}
onwards. The same applies for \code{strength_Aa}, \code{strength_aa} and
\code{strength_A}.}

\item{strength_Aa}{The selection strength for the heterozygote.}

\item{strength_aa}{The selection strength for the recessive homozygote.}

\item{strength_A}{This sets the strength for the selected allele in a
haploid model or a diploid model with additive selection.
\code{strength_AA}, \code{strength_Aa}, \code{strength_aa}
are ignored when this is argument is given.}

\item{population}{The population in which the allele is selected. Can either
be \code{all} for all population, or the number of a population.}

\item{time}{The time at which the selection starts if \code{start == TRUE}
(looking forwards in time), or the time at which the selection strength
changes if \code{start == FALSE}. The new strength applies for the time
period further into the past in this case.}

\item{start}{Whether selection should start at this time point. At this time,
the selected allele is introduced in the population with an initial
starting frequency. This must be set to \code{TRUE} for exactly one
selection feature in the model. The values of \code{start_frequency},
\code{Ne}, \code{position} and \code{force_keep} are used for the model.
You can add additional selection feature to the model to set the
selection strength for more demes or change it at different time points,
but these need to have \code{start = FALSE}.}

\item{start_frequency}{The start frequency at which the selected allele is
introduced at \code{time}. If the model has multiple population, this
can either be a numeric vector that contains the initial frequency for each
population or a single number. In the latter case, the value is used for
all population specified with \code{populations}, and 0 is used for all
other populations.}

\item{Ne}{The effective population size that is used for the forward
simulations.}

\item{position}{The position of the selected site, relative to the
simulated sequence. Values between 0 and 1 are within the simulated area,
while smaller values are to the left of it and larger ones to the right.}

\item{force_keep}{Whether to restart simulations in which the selected goes to
extinction or not.}

\item{locus_group}{The loci for which this features is used. Can either be
\code{"all"} (default), in which case the feature is used for simulating
all loci, or a numeric vector. In the latter case, the feature is only
used for the loci added in \code{locus_} commands  with the corresponding
index starting from 1 in order in which the commands where added to the
model. For example, if a model has
\code{locus_single(10) + locus_averaged(10, 11) + locus_single(12)} and
this argument is \code{c(2, 3)}, than the feature is used for all but
the first locus (that is locus 2 - 12).}
}
\value{
The feature, which can be added to a model created with
  \code{\link{coal_model}} using \code{+}.
}
\description{
This feature adds selection to a model. Only one site per locus can be under
selection. Using this feature requires that \code{msms} is installed, see
\code{\link{activate_msms}}.
}
\examples{
# Positive additive selection in population 2:
model <- coal_model(c(10, 13), 1, 10000) +
  feat_pop_merge(.5, 2, 1) +
  feat_selection(strength_A = 1000,
                 population = 2,
                 time = par_named("tau")) +
  feat_mutation(100) +
  feat_recombination(10) +
  sumstat_tajimas_d(population = 2)
\dontrun{simulate(model, pars = c(tau = 0.03))}
}
\seealso{
For using rates that variate between the loci in a model:
  \code{\link{par_variation}}, \code{\link{par_zero_inflation}}

For summary statistics that are sensitive for selection:
  \code{\link{sumstat_tajimas_d}}, \code{\link{sumstat_ihh}},
  \code{\link{sumstat_omega}}, \code{\link{sumstat_mcmf}}

For creating a model: \code{\link{coal_model}}

Other features: 
\code{\link{feat_growth}()},
\code{\link{feat_ignore_singletons}()},
\code{\link{feat_migration}()},
\code{\link{feat_mutation}()},
\code{\link{feat_outgroup}()},
\code{\link{feat_pop_merge}()},
\code{\link{feat_recombination}()},
\code{\link{feat_sample}()},
\code{\link{feat_size_change}()},
\code{\link{feat_unphased}()}
}
\concept{features}
