% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cobalt-package.R
\docType{package}
\name{cobalt-package}
\alias{cobalt}
\alias{cobalt-package}
\title{cobalt: Covariate Balance Tables and Plots}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

A set of tools for assessing covariate balance in observational studies numerically and graphically. The functions provide integration with the major R packages used for balancing covariates, including \pkg{MatchIt}, \pkg{WeightIt}, \pkg{twang}, \pkg{CBPS}, and many others, and support objects not made using these packages. They support binary, multi-category and continuous treatments, point and longitudinal treatments, and clustered and multiply imputed data.

The main functions of \pkg{cobalt} are the following:
\itemize{
\item \code{\link[=bal.tab]{bal.tab()}} - generate tables of balance statistics before and after matching, weighting, or subclassification
\item \code{\link[=bal.plot]{bal.plot()}} - generate plots to assess balance visually on one covariate at a time
\item \code{\link[=love.plot]{love.plot()}} - generate plots to summarize and report balance statistics
}

Other functions include \code{\link[=get.w]{get.w()}} for extracting weights from objects produced by other packages, \code{\link[=col_w_smd]{col_w_smd()}} (and friends documented on the same page) for computing (weighted) balance statistics outside of \code{bal.tab()}, \code{\link[=bal.compute]{bal.compute()}} for computing scalar balance statistics efficiently, and \code{\link[=splitfactor]{splitfactor()}} for splitting factor variables in a dataset into dummy variables.

\pkg{cobalt} has several vignettes, which can be accessed using \code{vignette(package = "cobalt")} or visiting the website at \url{https://ngreifer.github.io/cobalt/}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://ngreifer.github.io/cobalt/}
  \item \url{https://github.com/ngreifer/cobalt}
  \item Report bugs at \url{https://github.com/ngreifer/cobalt/issues}
}

}
\author{
\strong{Maintainer}: Noah Greifer \email{noah.greifer@gmail.com} (\href{https://orcid.org/0000-0003-3067-7154}{ORCID})

}
\keyword{internal}
