% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cocoResid.R
\name{cocoResid}
\alias{cocoResid}
\title{Residual Based Model Assessment Procedure}
\usage{
cocoResid(coco, val.num = 1e-10)
}
\arguments{
\item{coco}{An object of class "coco}

\item{val.num}{A non-negative real number that halts the calculation once the cumulative probability reaches 1-\code{val.num}}
}
\value{
a list that includes the (Pearson) residuals, conditional expectations, conditional variances,
and information on the model specifications.
}
\description{
Calculates the (Pearson) residuals of a fitted model for model evaluation purposes.
}
\details{
The Pearson residuals are computed as the scaled
deviation of the observed count from its conditional expectation given the relevant
past history, including covariates, if applicable. If a fitted model is correctly specified,
the Pearson residuals should exhibit mean zero, variance one, and no significant serial correlation.
}
\author{
Manuel Huth
}
