% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codemetar-package.R
\docType{package}
\name{codemetar-package}
\alias{codemetar}
\alias{codemetar-package}
\title{codemetar: generate codemeta metadata for R packages}
\description{
The 'CodeMeta' Project defines a JSON-LD format for describing software metadata,
as detailed at https://codemeta.github.io.
This package provides utilities to generate, parse, and modify codemeta.jsonld
files automatically for R packages, as well as tools and examples for working
with codemeta JSON-LD more generally.
}
\details{
It has three main goals:

\itemize{
\item Quickly generate a valid codemeta.json file from any valid R package.
  To do so, we automatically extract as much metadata as possible using
  the DESCRIPTION file, as well as extracting metadata from other common
  best-practices such as the presence of Travis and other badges in README, etc.
\item Facilitate the addition of further metadata fields into a codemeta.json
  file, as well as general manipulation of codemeta files.
\item Support the ability to crosswalk between terms used in other metadata standards,
  as identified by the CodeMeta Project Community, see https://codemeta.github.io/crosswalk
}

To learn more about codemetar, start with the vignettes:
`browseVignettes(package = "codemetar")`

For more general information about the CodeMeta Project for defining software metadata,
see https://codemeta.github.io.  In particular, new users might want to start with
the User Guide (https://codemeta.github.io/user-guide/), while those looking to learn
more about JSON-LD and consuming existing codemeta files should see the
Developer Guide (https://codemeta.github.io/developer-guide/).
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/ropensci/codemetar}
  \item \url{https://ropensci.github.io/codemetar}
  \item Report bugs at \url{https://github.com/ropensci/codemetar/issues}
}

}
\author{
\strong{Maintainer}: Carl Boettiger \email{cboettig@gmail.com} (0000-0002-1642-628X) [copyright holder]

Authors:
\itemize{
  \item Maëlle Salmon (0000-0002-2815-0399) [contributor]
}

Other contributors:
\itemize{
  \item Anna Krystalli (0000-0002-2378-4915) [reviewer, contributor]
  \item Toph Allen (0000-0003-4580-091X) [reviewer]
  \item rOpenSci (https://ropensci.org/) [funder]
  \item Katrin Leinweber (0000-0001-5135-5758) [contributor]
  \item Noam Ross (0000-0002-2136-0000) [contributor]
  \item Arfon Smith [contributor]
  \item Jeroen Ooms (0000-0002-4035-0289) [contributor]
  \item Sebastian Meyer (0000-0002-1791-9449) [contributor]
  \item Michael Rustler (0000-0003-0647-7726) [contributor]
  \item Hauke Sonnenberg (0000-0001-9134-2871) [contributor]
}

}
