#' Display package version for \pkg{codename}
#'
#' @description \code{codename_message()} produces a message about the package version.
#'
#' @return \code{codename_message()} produces a message about the installed version of \pkg{codename}. Successive updates
#' may (understandably) break an expected output from a reproducible seed in the \code{codename()} function. This just
#' adds an extra layer of transparency.
#'
#' @author Steven V. Miller
#'
#'
#' @examples
#'
#' codename_message()
#'

codename_message <- function() {

  message(paste0("code name generated by {codename} v.", packageVersion("codename")))

}
