% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/product-distributions.R
\name{product-distribution}
\alias{product-distribution}
\alias{dphi}
\alias{pphi}
\alias{dtau}
\alias{ptau}
\title{Frequency Distributions for MCA Parametric Testing}
\usage{
dphi(x, nu1, nu2, tol = .Machine$double.eps^0.5)

pphi(q, nu1, nu2, lower.tail = TRUE, tol = .Machine$double.eps^0.5)

dtau(x, nu, tol = .Machine$double.eps^0.5)

ptau(q, nu, lower.tail = TRUE, tol = .Machine$double.eps^0.5)
}
\arguments{
\item{x, q}{A vector of quantile.}

\item{nu1, nu2, nu}{Degrees of freedom (>0, may be non-integer; \code{Inf} is
allowed.}

\item{tol}{The tolerance used during numerical estimation.}

\item{lower.tail}{Logical; if TRUE (default), probabilities are P[X <= x],
otherwise, P[X > x].}
}
\value{
\code{dphi} and \code{dtau} return the density functions, whereas
\code{pphi} and \code{ptau} return the distribution functions.
}
\description{
Density and distribution functions of the phi statistic, which is the product
of two Fisher-Snedecor distributions or the tau statistic, which is the
product of two Student's t distributions.
}
\details{
The density distribution of a variable \code{z} that is the product
of two random variables `x` and `y` with density distributions f(x) and g(y),
respectively, is the integral f(x) * g(z/x) / abs(x) dx over the intersection
of the domains of `x` and `y`.

\code{dphi} estimates density values using numerical integration
(\code{\link{integrate}}) the Fisher-Scedecor \code{\link{df}} density
distribution function. Following the algebra of Multiscale Codependence
Analysis, f(x) has df1 = nu1 and df2 = nu1 * nu2 degrees of freedom and g(x)
has 'df1 = 1' and 'df2 = nu2' degrees of freedom. Hence, that product
distribution has two parameters.

\code{pphi} integrates \code{dphi} in the interval [0,q] when
\code{lower.tail = TRUE} (the default) and on the interval [q,\code{Inf}]
when \code{lower.tail = FALSE}.

\code{dtau} and \code{ptau} are similar to \code{dphi} and \code{pphi},
respectively. \code{pphi} integrates \code{dphi}, with f(x) and f(y) being
two Student's t distribution with \code{nu} degrees of freedom. It is called
by functions \code{\link{test.cdp}} and \code{\link{permute.cdp}} to perform
hypothesis tests for single response variables, in which case unilateral
tests can be performed.
}
\section{Functions}{
\itemize{
\item \code{dphi()}: Probability density function for the phi statistics

\item \code{pphi()}: Distribution function for the phi statistics

\item \code{dtau()}: Probability density function for the tau statistics

\item \code{ptau()}: Distribution function for the tau statistics

}}
\examples{
### Displays the phi probability distribution for five different numbers
### of degrees of freedom:
x <- 10^seq(-4, 0.5, 0.05)
plot(y = dphi(x, 1, 10), x = x, type = "l", col = "black", las = 1,
ylab = "pdf", ylim = c(0, 0.5))
lines(y = dphi(x, 3, 10), x = x, col = "purple")
lines(y = dphi(x, 5, 70), x = x, col = "blue")
lines(y = dphi(x, 12, 23), x = x, col = "green")
lines(y = dphi(x, 35, 140), x = x, col = "red")

### Displays the density distribution function for 10 degrees of freedom.
x <- 10^seq(-4, 0.5, 0.05)
y <- dphi(x, 5, 70)
plot(y = y, x = x, type = "l", col = "black", las = 1, ylab = "Density",
     ylim = c(0, 0.5))
polygon(x = c(x[81L:91], x[length(x)], 1), y = c(y[81L:91], 0, 0),
        col = "grey")
text(round(pphi(1, 5, 70, lower.tail=FALSE), 3), x = 1.75, y = 0.05)

## Idem for the tau distribution:
x <- c(-(10^seq(0.5, -4, -0.05)), 10^seq(-4, 0.5, 0.05))
plot(y = dtau(x, 1), x = x, type = "l", col = "black", las = 1,
     ylab = "pdf", ylim = c(0, 0.5))
lines(y = dtau(x, 2), x = x, col = "purple")
lines(y = dtau(x, 5), x = x, col="blue")
lines(y = dtau(x, 10), x = x, col="green")
lines(y = dtau(x, 100), x = x, col="red")

y <- dtau(x, 10)
plot(y = y, x = x, type = "l", col = "black", las = 1, ylab = "Density",
     ylim = c(0, 0.5))
polygon(x = c(x[which(x==1):length(x)], x[length(x)],1),
        y = c(y[which(x==1):length(x)], 0, 0), col = "grey")
text(round(ptau(1, 10, lower.tail = FALSE), 3), x = 1.5, y = 0.03)
polygon(x = c(-1, x[1L], x[1L:which(x==-1)]),
        y = c(0, 0, y[1L:which(x==-1)]), col="grey")
text(round(ptau(-1, 10), 3), x = -1.5, y = 0.03)

}
\references{
Springer, M. D. 1979. The algebra of random variables. John Wiley and Sons
Inc., Hoboken, NJ, USA.

Guénard, G., Legendre, P., Boisclair, D., and Bilodeau, M. 2010. Multiscale
codependence analysis: an integrated approach to analyse relationships across
scales. Ecology 91: 2952-2964

Guénard, G. Legendre, P. 2018. Bringing multivariate support to multiscale
codependence analysis: Assessing the drivers of community structure across
spatial scales. Meth. Ecol. Evol. 9: 292-304
}
\seealso{
\link{test.cdp}
}
\author{
\packageAuthor{codep}
Maintainer: \packageMaintainer{codep}
}
