% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classcodes.R
\name{classcodes}
\alias{classcodes}
\alias{as.classcodes}
\alias{as.classcodes.classcodes}
\alias{as.classcodes.data.frame}
\alias{is.classcodes}
\title{Classcodes methods}
\usage{
as.classcodes(x, ...)

\method{as.classcodes}{classcodes}(
  x,
  ...,
  regex = attr(x, "regexpr"),
  indices = attr(x, "indices"),
  hierarchy = attr(x, "hierarchy")
)

\method{as.classcodes}{data.frame}(
  x,
  ...,
  regex = NULL,
  indices = NULL,
  hierarchy = attr(x, "hierarchy"),
  .name = NULL
)

is.classcodes(x)
}
\arguments{
\item{x}{data frame with columns described in the details section.
Alternatively a \code{classcodes} object to be modified.}

\item{...}{arguments passed between methods#'}

\item{regex, indices}{character vector with names of columns in \code{x} containing
regular expressions/indices.}

\item{hierarchy}{named list of pairwise group names to appear as superior and
subordinate for indices.
To be used for indexing when the subordinate class is redundant
(see the details section of \code{\link{elixhauser}} for an example).}

\item{.name}{used internally for name dispatch}
}
\value{
Object of class \code{classcodes} (inheriting from data frame)
with additional attributes:
\itemize{
\item \verb{code:} the coding used (for example "icd10", or "ATC").
\code{NULL} for unknown/arbitrary coding.
\item \verb{regexprs:} name of columns with regular expressions
(as specified by the \code{regex}argument)
\item \verb{indices:} name of columns with (optional) index weights
(as specified by the \code{indices}argument)
\item \verb{hierarchy:} list as specified by the \code{hierarchy} argument.
\item \verb{name:} name as specified by the \code{.name} argument.
}
}
\description{
\code{classcodes} are classification schemes based on regular expression stored in
data frames. These are essential to the package and constitute the third
part of the triad of case data, code data and a classification scheme.
}
\details{
A classcodes object is a data frame with mandatory columns:
\itemize{
\item \code{group}: unique and non missing class names
\item At least one column with regular expressions
(\link{regex} without Perl-like versions) defining class
membership. Those columns can have arbitrary names
(as specified by the \code{regex} argument).
Occurrences of non unique regular expressions will lead to the same class
having multiple names. This is accepted but will raise a warning.
Classes do not have to be disjunct.
}

The object can have additional optional columns:
\itemize{
\item \code{description}: description of each category
\item \code{condition}: a class might have conditions additional to what
is expressed by the regular expressions.
If so, these should be specified as quoted
expressions that can be evaluated within the data frame used by
\code{\link[=classify]{classify()}}
\item weights for each class used by
\code{\link[=index]{index()}}. Could be more than one and could have arbitrary names
(as specified by the \code{indices}argument).
}
}
\examples{
# The Elixhauser comorbidity classification is already a classcodes object
is.classcodes(coder::elixhauser)

# Strip its class attributes to use in examples
df <- as.data.frame(coder::elixhauser)

# Specify which columns store regular expressions and indices
# (assume no hierarchy)
elix <-
  as.classcodes(
    df,
    regex     = c("icd10", "icd10_short", "icd9cm", "icd9cm_ahrqweb", "icd9cm_enhanced"),
    indices   = c("sum_all", "sum_all_ahrq", "walraven",
                "sid29", "sid30", "ahrq_mort", "ahrq_readm"),
    hierarchy = NULL
  )
elix

# Specify hierarchy for patients with different types of cancer and diabetes
# See `?elixhauser` for details
as.classcodes(
  elix,
  hierarchy = list(
    cancer   = c("metastatic cancer", "solid tumor"),
    diabetes = c("diabetes complicated", "diabetes uncomplicated")
  )
)

# Several checks are performed to not allow any erroneous classcodes object
\dontrun{
  as.classcodes(iris)
  as.classcodes(iris, regex = "Species")
}
}
\seealso{
\code{vignette("classcodes")}
\code{vignette("Interpret_regular_expressions")}
The package have several default classcodes included, see \code{\link[=all_classcodes]{all_classcodes()}}.

Other classcodes: 
\code{\link{all_classcodes}()},
\code{\link{as.data.frame.classified}()},
\code{\link{codebook}()},
\code{\link{print.classcodes}()},
\code{\link{print.classified}()},
\code{\link{set_classcodes}()},
\code{\link{summary.classcodes}()},
\code{\link{visualize.classcodes}()}

Other classcodes: 
\code{\link{all_classcodes}()},
\code{\link{as.data.frame.classified}()},
\code{\link{codebook}()},
\code{\link{print.classcodes}()},
\code{\link{print.classified}()},
\code{\link{set_classcodes}()},
\code{\link{summary.classcodes}()},
\code{\link{visualize.classcodes}()}
}
\concept{classcodes}
