% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variance_ratio.R
\name{variance_ratio}
\alias{variance_ratio}
\title{Variance Ratio}
\usage{
variance_ratio(df, time.var, species.var, abundance.var, bootnumber,
  replicate.var = NA, average.replicates = TRUE, level = 0.95, li, ui)
}
\arguments{
\item{df}{A data frame containing time, species and abundance columns and an optional column of replicates}

\item{time.var}{The name of the time column}

\item{species.var}{The name of the species column}

\item{abundance.var}{The name of the abundance column}

\item{bootnumber}{The number of null model iterations used to calculated confidence intervals}

\item{replicate.var}{The name of the (optional) replicate column}

\item{average.replicates}{If true returns the variance ratio and CIs averaged}

\item{level}{The confidence level for the null mean}

\item{li}{(deprecated) lower confidence interval}

\item{ui}{(deprecated) upper confidence interval
across replicates; if false returns the variance ratio and CI for each replicate. Defaults to true.}
}
\value{
The variance_ratio function returns a data frame with the following attributes:
\itemize{
 \item{VR: }{A numeric column with the actual variance ratio value.}
 \item{lowerCI: }{A numeric column with the lowest confidence interval value.}
 \item{upperCI: }{A numeric column with the highest confidence interval value.}
 \item{nullmean: }{A numeric column with the average null variance ratio value.}
 \item{replicate.var: }{A column that has same name and type as the replicate.var column, if replication is specified.}
}
}
\description{
Computes the ratio of the variance of aggregate species abundances
in a community to the sum of the variances of individual, component species. A
variance ratio = 1 indicates that species do not covary, a variance ratio > 1
indicates predominately positive covariance among species and a variance
ratio < 1 indicates predominately negative covariance (Schluter 1984).

Includes a cyclic shift null modeling option to test if the variance ratio significantly
differs from 1. The null community is created by randomly selecting different
starting points for each species' time series, which generates a community in
which species abundances vary independently but within-species autocorrelation
is maintained (Hallett et al. 2014). This randomization is repeated a user-specific
number of times and confidence intervals are reported for the resultant null
distribution of variance ratios. If the dataframe includes multiple replicates,
the variance ratios for the actual and null communities are averaged within each
iteration unless specified otherwise.
}
\details{
The input data frame needs to contain columns for time, species and abundance;
time.var, species.var and abundance.var are used to indicate which columns
contain those variables. If multiple replicates are included in the data frame,
that column should be specified with replicate.var. Each replicate should
reflect a single experimental unit - there must be a single abundance value
per species within each time point and replicate.

Null model confidence intervals default to the standard lowest 2.5\% and
upper 97.5\% of the null distribution, typically these do not need to be change,
but they can be user-modified to set more stringent CIs.
 @references
 Hallett, Lauren M., Joanna S. Hsu, Elsa E. Cleland, Scott L. Collins,
 Timothy L. Dickson, Emily C. Farrer, Laureano A. Gherardi, et al. (2014)
 "Biotic Mechanisms of Community Stability Shift along a Precipitation Gradient."
 Ecology 95, no. 6: 1693-1700. doi: 10.1890/13-0895.1

 Schluter, Dolph. (1984) "A Variance Test for Detecting Species Associations,
 with Some Example Applications." Ecology 65, no. 3: 998-1005. doi:10.2307/1938071.
}
\examples{
 data(knz_001d)

 # Calculate the variance ratio and CIs averaged within replicates
 # Here the null model is repeated once, for final use it is recommended to set a
 # large bootnumber (eg, 10000)

 res_averagedreplicates <- variance_ratio(knz_001d,
               time.var = "year",
               species.var = "species",
               abundance.var = "abundance",
               bootnumber = 1,
               replicate = "subplot")

 #Calculate the variance ratio and CIs for each replicate

 res_withinreplicates <- variance_ratio(knz_001d,
               time.var = "year",
               species.var = "species",
               abundance.var = "abundance",
               bootnumber = 1,
               replicate = "subplot",
               average.replicates = FALSE)
}
