% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_change.R
\name{curve_change}
\alias{curve_change}
\title{Curve Change}
\usage{
curve_change(
  df,
  time.var,
  species.var,
  abundance.var,
  replicate.var = NULL,
  reference.time = NULL
)
}
\arguments{
\item{df}{A data frame containing time, species, and abundance columns and an
optional columns of replicates.}

\item{time.var}{The name of the time column.}

\item{species.var}{The name of the species column.}

\item{abundance.var}{The name of the abundance column.}

\item{replicate.var}{The name of the optional replicate column. If specified,
replicate must be unique within the dataset and cannot be nested within
treatments or blocks.}

\item{reference.time}{The name of the optional time point that all other time
points should be compared to (e.g. the first year of data). If not
specified, each comparison is between consecutive time points (the first
and second year, second and third year, etc.)}
}
\value{
The curve_change function returns a data frame with the following
  attributes:
\itemize{
 \item{time.var: }{A column with the specified time.var and a second column,
 with '2' appended to the name. Time is subtracted from time2.}
 \item{curve_change: }{A numeric column of the change in curves between time
 points.}
 \item{replicate.var: }{A column that has same name and type as the
 replicate.var column, if specified.}
}
}
\description{
Calculates the area difference between two rank abundance curves
  between two time periods. If replicate is specified, it must be measured in
  both time points, otherwise it will be dropped for that time period
  comparison.
}
\examples{
data(pplots)
# Without replicates
df <- subset(pplots, plot == 25)
curve_change(df = df,
           species.var = "species",
           abundance.var = "relative_cover",
           time.var = "year")

# With replicates
df <- subset(pplots, year < 2004 & plot \%in\% c(6, 25, 32))
curve_change(df = df,
           species.var = "species",
           abundance.var = "relative_cover",
           replicate.var = "plot",
           time.var = "year")
           
# With reference year
df <- subset(pplots, year < 2005 & plot \%in\% c(6, 25, 32))
curve_change(df = df,
           species.var = "species",
           abundance.var = "relative_cover",
           replicate.var = "plot",
           time.var = "year",
           reference.time = 2002)
}
\references{
Avolio et al. Submitted
}
