\name{coefplot.rxLinMod}
\alias{coefplot.rxLinMod}
\title{coefplot.rxLinMod}
\usage{
  \method{coefplot}{rxLinMod} (...)
}
\arguments{
  \item{\dots}{All arguments are passed on to
  \code{\link{coefplot.lm}}.  Please see that function for
  argument information.}
}
\value{
  A ggplot object.  See \code{\link{coefplot.lm}} for more
  information.
}
\description{
  Dotplot for rxLinMod coefficients
}
\details{
  A graphical display of the coefficients and standard
  errors from a fitted rxLinMod model

  \code{\link{coefplot}} is the S3 generic method for
  plotting the coefficients from a fitted model.

  For more information on this function and it's arguments
  see \code{\link{coefplot.lm}}
}
\examples{
\dontrun{
data(diamonds)
mod3 <- rxLinMod(price ~ carat + cut + x, data=diamonds)
coefplot(mod3)
}
}
\author{
  Jared P. Lander www.jaredlander.com
}

