% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr-indic.R
\name{ConceptIndegreeIndiv}
\alias{ConceptIndegreeIndiv}
\title{Indegree of vertices by document}
\usage{
ConceptIndegreeIndiv(project, sep = ">", coder = "qcoder")
}
\arguments{
\item{project}{A QDA project, a list as generated by the ProjectCMap function.}

\item{sep}{(==Depreciated, with RQDA project==) A character string (often a single character) that is used in RQDA in order to express the relationships between two variables. Default is "_" if codes used in RQDA are of the form : "x_y" (\emph{i.e.} relationship from x to y), but it is possible to use ">", "->", "-->" or even "--->"}

\item{coder}{A character string indicating the coding tool used for coding the QDA. The only tool supported now is 'qcoder'. Earlier version of cogmapr worked with "RQDA" project (no more maintened).}
}
\value{
A data frame of Indegree by document (ICM)
}
\description{
Indegree of vertices by document
}
\details{
Indegree of vertices by document
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

ConceptIndegreeIndiv(my.project)
}
