% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cointReg-FM-OLS.R
\name{cointRegFM}
\alias{cointRegFM}
\title{Fully Modified OLS}
\usage{
cointRegFM(x, y, deter, kernel = c("ba", "pa", "qs", "tr"),
  bandwidth = c("and", "nw"), demeaning = FALSE, check = TRUE, ...)
}
\arguments{
\item{x}{[\code{numeric} | \code{matrix} | \code{data.frame}]\cr
RHS variables on which to apply the FM-OLS estimation (see Details).}

\item{y}{[\code{numeric} | \code{matrix} | \code{data.frame}]\cr
LHS variable(s) on which to apply the FM-OLS estimation (see Details).
Usually one-dimensional, but a \code{matrix} or
\code{data.frame} with more than one column is also possible.}

\item{deter}{[\code{numeric} | \code{matrix} | \code{data.frame} |
            \code{NULL}]\cr
Deterministic variable to include in the equation (see Details). If it's
\code{NULL} or missing, no deterministic variable is included in the model.}

\item{kernel}{[\code{character(1)}]\cr
The kernel function to use for calculating the long-run variance.
Default is Bartlett kernel (\code{"ba"}), see Details for alternatives.}

\item{bandwidth}{[\code{character(1)} | \code{integer(1)}]\cr
The bandwidth to use for calculating the long-run variance.
Default is Andrews (1991) (\code{"and"}), an alternative is Newey West
(1994) (\code{"nw"}).}

\item{demeaning}{[\code{logical}]\cr
Demeaning of residuals in \code{\link{getLongRunVar}}.
Default is \code{FALSE}.}

\item{check}{[\code{logical}]\cr
Wheather to check (and if necessary convert) the arguments.
See \code{\link{checkVars}} for further information.}

\item{...}{Arguments passed to \code{\link{getBandwidthNW}}.}
}
\value{
[\code{cointReg}]. List with components:
\describe{
  \item{\code{delta} [\code{numeric} | \code{matrix}]}{
    coefficients as vector / matrix}

  \item{\code{beta} [\code{numeric} | \code{matrix}]}{
    coefficients as vector / matrix}

  \item{\code{theta} [\code{numeric} | \code{matrix}]}{
    combined coefficients of
    \code{beta} and \code{delta} as vector / matrix}

  \item{\code{sd.theta} [\code{numeric}]}{
    standard errors for \code{theta}}

  \item{\code{t.theta} [\code{numeric}]}{
    t-values for \code{theta}}

  \item{\code{p.theta} [\code{numeric}]}{
    p-values for \code{theta}}

  \item{\code{residuals} [\code{numeric}]}{
    FM-OLS residuals (first value is always missing)}

  \item{\code{omega.u.v} [\code{numeric}]}{
    conditional long-run variance based on OLS residuals.}

  \item{\code{varmat} [\code{matrix}]}{
    variance-covariance matrix}

  \item{\code{Omega} [\code{list}]}{
    the whole long-run variance matrix and parts of it}

  \item{\code{beta.OLS} [\code{numeric} | \code{matrix}]}{
    OLS coefficients as vector / matrix}

  \item{\code{delta.OLS} [\code{numeric} | \code{matrix}]}{
    OLS coefficients as vector / matrix}

  \item{\code{u.OLS} [\code{numeric}]}{
    OLS residuals}

  \item{\code{bandwidth} [\code{list}]}{
    \code{number} and \code{name} of bandwidth}

  \item{\code{kernel} [\code{character}]}{
    abbr. name of kernel type}
}
}
\description{
Computes the Phillips and Hansen (1990) Fully Modified OLS estimator.
}
\details{
The equation for which the FM-OLS estimator is calculated:
\deqn{y = \delta \cdot D + \beta \cdot x + u}{y = \delta * D + \beta * x + u}
with \eqn{D} as the deterministics matrix.
Then \eqn{\theta = (\delta', \beta')'} is the full parameter vector.

The calculation of t-values and the variance-covariance matrix is only
possible, if \code{y} is one-dimensional.
}
\examples{
set.seed(1909)
x1 = cumsum(rnorm(100, mean = 0.05, sd = 0.1))
x2 = cumsum(rnorm(100, sd = 0.1)) + 1
x3 = cumsum(rnorm(100, sd = 0.2)) + 2
x = cbind(x1, x2, x3)
y = x1 + x2 + x3 + rnorm(100, sd = 0.2) + 1
deter = cbind(level = 1, trend = 1:100)
test = cointRegFM(x, y, deter, kernel = "ba", bandwidth = "and")
print(test)

}
\references{
\itemize{
    \item Phillips, P.C.B. and B. Hansen (1990): "Statistical Inference in
          Instrumental Variables Regression with I(1) Processes,"
          \emph{Review of Economic Studies}, 57, 99--125,
          \href{http://dx.doi.org/10.2307/2297545}{DOI:10.2307/2297545}.
  }
}
\seealso{
Other cointReg: \code{\link{cointRegD}},
  \code{\link{cointRegIM}}, \code{\link{cointReg}},
  \code{\link{plot.cointReg}}, \code{\link{print.cointReg}}
}

