% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/susie.R
\name{coloc.bf_bf}
\alias{coloc.bf_bf}
\title{Coloc data through Bayes factors}
\usage{
coloc.bf_bf(
  bf1,
  bf2,
  p1 = 1e-04,
  p2 = 1e-04,
  p12 = 5e-06,
  overlap.min = 0.5,
  trim_by_posterior = TRUE
)
}
\arguments{
\item{bf1}{named vector of BF, or matrix of BF with colnames (cols=snps, rows=signals)}

\item{bf2}{named vector of BF, or matrix of BF with colnames (cols=snps, rows=signals)}

\item{p1}{prior probability a SNP is associated with trait 1, default 1e-4}

\item{p2}{prior probability a SNP is associated with trait 2, default 1e-4}

\item{p12}{prior probability a SNP is associated with both traits, default 1e-5}

\item{overlap.min}{see trim_by_posterior}

\item{trim_by_posterior}{it is important that the signals to be colocalised
are covered by adequate numbers of snps in both datasets. If TRUE, signals
for which snps in common do not capture least overlap.min proportion of
their posteriors support are dropped and colocalisation not attempted.}
}
\value{
coloc.signals style result
}
\description{
Colocalise two datasets represented by Bayes factors
}
\details{
This is the workhorse behind many coloc functions
}
\author{
Chris Wallace
}
