% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorpatch_impl.R
\name{DistColor}
\alias{DistColor}
\title{Computes the distance of to colors within a certain colorspace}
\usage{
DistColor(x, y, color.space = "LAB")
}
\arguments{
\item{x}{First color to be compared}

\item{y}{Second color to be compared}

\item{color.space}{Defaults to "LAB" (can be anything within the colorspace package) see \link[colorspace:color-class]{colorspace::color}}
}
\value{
L2 distance of the two colors within the given coordinate space
}
\description{
Computes the distance of to colors within a certain colorspace
}
\examples{
library(colorspace)
library(colorpatch)
DistColor(sRGB(0.1,0.5,0), sRGB(0.2,0.7,1.0), "LUV")
}
\seealso{
\link[colorspace:color-class]{colorspace::color}, \code{\link[=DistColorFun]{DistColorFun()}}
}
