% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rainbow_hcl.R
\name{rainbow_hcl}
\alias{rainbow_hcl}
\alias{heat_hcl}
\alias{terrain_hcl}
\alias{diverging_hsv}
\alias{diverge_hsv}
\title{HCL (and HSV) Color Palettes Corresponding to Base R Palettes}
\usage{
rainbow_hcl(
  n,
  c = 50,
  l = 70,
  start = 0,
  end = 360 * (n - 1)/n,
  gamma = NULL,
  fixup = TRUE,
  alpha = 1,
  ...
)

heat_hcl(
  n,
  h = c(0, 90),
  c. = c(100, 30),
  l = c(50, 90),
  power = c(1/5, 1),
  gamma = NULL,
  fixup = TRUE,
  alpha = 1,
  ...
)

terrain_hcl(
  n,
  h = c(130, 0),
  c. = c(80, 0),
  l = c(60, 95),
  power = c(1/10, 1),
  gamma = NULL,
  fixup = TRUE,
  alpha = 1,
  ...
)

diverging_hsv(
  n,
  h = c(240, 0),
  s = 1,
  v = 1,
  power = 1,
  gamma = NULL,
  fixup = TRUE,
  alpha = 1,
  ...
)
}
\arguments{
\item{n}{the number of colors (\eqn{\ge 1}{>= 1}) to be in the palette.}

\item{c, c.}{chroma value in the HCL color description.}

\item{l}{luminance value in the HCL color description.}

\item{start}{the hue at which the rainbow begins.}

\item{end}{the hue at which the rainbow ends.}

\item{gamma}{Deprecated.}

\item{fixup}{logical. Should the color be corrected to a valid RGB value
before correction?}

\item{alpha}{numeric vector of values in the range \code{[0, 1]} for alpha
transparency channel (0 means transparent and 1 means opaque).}

\item{\dots}{Other arguments passed to \code{\link{hex}}.}

\item{h}{hue value in the HCL or HSV color description, has to be in [0, 360]
for HCL and in [0, 1] for HSV colors.}

\item{power}{control parameter determining how chroma and luminance should
be increased (1 = linear, 2 = quadratic, etc.).}

\item{s}{saturation value in the HSV color description.}

\item{v}{value value in the HSV color description.}
}
\value{
A character vector with (s)RGB codings of the colors in the palette.
}
\description{
Color palettes based on the HCL (and HSV) color space to replace
base R palettes.
}
\details{
Based on the general qualitative, sequential, and diverging \code{\link{hcl_palettes}}
within the colorspace package, convenience functions are provided as
alternatives to standard base R palettes (which are highly saturated
and too flashy).

\code{rainbow_hcl} computes a rainbow of colors via \code{\link{qualitative_hcl}}
defined by different hues given a single value of each chroma and luminance.
It corresponds to \code{\link{rainbow}} which computes a rainbow in HSV
space.

\code{heat_hcl} is an implementation of \code{\link[grDevices]{heat.colors}} in
HCL space based on a call to \code{\link{sequential_hcl}}. Similarly,
\code{terrain_hcl} palette also calls \code{sequential_hcl} with different
parameters, providing colors similar in spirit to \code{terrain.colors}
in HCL space.

\code{diverging_hsv} (and equivalently its alias \code{diverge_hsv})
provides an HSV-based version of \code{\link{diverging_hcl}}. Its purpose
is mainly didactic to show that HSV-based diverging palettes are less
appealing, more difficult to read and more flashy than HCL-based diverging
palettes. \code{diverging_hsv} is similar to \code{\link[grDevices]{cm.colors}}.
}
\examples{
## convenience demo function
wheel <- function(col, radius = 1, ...)
  pie(rep(1, length(col)), col = col, radius = radius, ...) 

## compare base and colorspace palettes
## (in color and desaturated)
par(mar = rep(0, 4), mfrow = c(2, 2))
## rainbow color wheel
wheel(rainbow_hcl(12))
wheel(rainbow(12))
wheel(desaturate(rainbow_hcl(12)))
wheel(desaturate(rainbow(12)))

## diverging red-blue colors
swatchplot(
  diverging_hsv(7),
  desaturate(diverging_hsv(7)),
  diverging_hcl(7, c = 100, l = c(50, 90)),
  desaturate(diverging_hcl(7, c = 100, l = c(50, 90))),
  nrow = 2
)

## diverging cyan-magenta colors
swatchplot(
  cm.colors(7),
  desaturate(cm.colors(7)),
  diverging_hcl(7, "Cyan-Magenta"), ## or, similarly: Tropic
  desaturate(diverging_hcl(7, "Cyan-Magenta")),
  nrow = 2
)

## heat colors
swatchplot(
  heat.colors(12),
  desaturate(heat.colors(12)),
  heat_hcl(12),
  desaturate(heat_hcl(12)),
  nrow = 2
)

## terrain colors
swatchplot(
  terrain.colors(12),
  desaturate(terrain.colors(12)),
  terrain_hcl(12),
  desaturate(terrain_hcl(12)),
  nrow = 2
)
}
\references{
Zeileis A, Hornik K, Murrell P (2009).  Escaping RGBland:
Selecting Colors for Statistical Graphics.  \emph{Computational Statistics &
Data Analysis}, \bold{53}, 3259--3270.
\doi{10.1016/j.csda.2008.11.033}
Preprint available from
\url{https://eeecon.uibk.ac.at/~zeileis/papers/Zeileis+Hornik+Murrell-2009.pdf}.

Stauffer R, Mayr GJ, Dabernig M, Zeileis A (2015).  Somewhere over the
Rainbow: How to Make Effective Use of Colors in Meteorological
Visualizations.  \emph{Bulletin of the American Meteorological Society},
\bold{96}(2), 203--216.
\doi{10.1175/BAMS-D-13-00155.1}
}
\seealso{
\code{\link[colorspace]{polarLUV}}, \code{\link[colorspace]{HSV}},
\code{\link[colorspace]{hex}}
}
\keyword{color}
