% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecometric_model_qual.R
\name{ecometric_model_qual}
\alias{ecometric_model_qual}
\title{Run an ecometric model for qualitative environmental variables}
\usage{
ecometric_model_qual(
  points_df,
  category_col,
  grid_bins_1 = NULL,
  grid_bins_2 = NULL,
  min_species = 3
)
}
\arguments{
\item{points_df}{Output first element of the list from \code{summarize_traits_by_point()}. A data frame with columns: \code{summ_trait_1}, \code{summ_trait_2}, \code{count_trait}, and the environmental variable.}

\item{category_col}{Name of the column containing the categorical trait.}

\item{grid_bins_1}{Number of bins for the first trait axis. If \code{NULL} (default),
the number is calculated automatically using Scott's rule via \code{optimal_bins()}.}

\item{grid_bins_2}{Number of bins for the second trait axis. If \code{NULL} (default),
the number is calculated automatically using Scott's rule via \code{optimal_bins()}.}

\item{min_species}{Minimum number of species with trait data per point (default = 3).}
}
\value{
A list containing:
\item{points_df}{Filtered input data frame with the following added columns:
\describe{
\item{bin_1}{Bin assignment code for first trait axis.}
\item{bin_2}{Bin assignment code for second trait axis.}
\item{prob_category}{Estimated probability of each environmental category per trait bin (e.g., \code{prob_1}, \code{prob_2}, etc.).}
\item{observed_probability}{Probability assigned to the observed category for each point.}
\item{predicted_probability}{Probability assigned to the predicted (most likely) category for each point.}
\item{predicted_category}{Predicted environmental category for each point.}
\item{correct_prediction}{Indicator for whether the predicted category matches the observed category (\code{"Yes"} or \code{"No"}).}
\item{env_anom}{Difference between predicted and observed category probabilities.}
}
}
\item{eco_space}{Raster-format data frame representing trait space bins with estimated environmental categories.}
\item{diagnostics}{Summary stats about bin usage and data coverage.}
\item{settings}{Metadata including the modeled trait.}
\item{prediction_accuracy}{Overall percentage of correct predictions.}
}
\description{
Builds an ecometric trait space for qualitative environmental variables,
estimating the most probable category and the probability of each category
at each trait bin combination. Also calculates prediction accuracy
and anomalies for each point.
}
\examples{
\donttest{
# Load internal data
data("geoPoints", package = "commecometrics")
data("traits", package = "commecometrics")
data("spRanges", package = "commecometrics")

# Step 1: Summarize trait values at sampling points
traitsByPoint <- summarize_traits_by_point(
  points_df = geoPoints,
  trait_df = traits,
  species_polygons = spRanges,
  trait_column = "RBL",
  species_name_col = "sci_name",
  continent = FALSE,
  parallel = FALSE
)

# Step 2: Run ecometric model using land cover class as qualitative variable
modelResult <- ecometric_model_qual(
  points_df = traitsByPoint$points,
  category_col = "vegetation",
  min_species = 3
)

# View the percentage of correctly predicted categories
print(modelResult$prediction_accuracy)
}
}
