% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comorbidity.R
\name{comorbidity}
\alias{comorbidity}
\title{Compute comorbidity scores.}
\usage{
comorbidity(x, id, code, score, assign0 = TRUE, factorise = FALSE,
  labelled = TRUE, tidy.codes = TRUE, parallel = FALSE,
  mc.cores = parallel::detectCores())
}
\arguments{
\item{x}{A tidy data frame with one column containing an individual ID and a column containing all diagnostic codes.}

\item{id}{Column of \code{x} containing the individual ID.}

\item{code}{Column of \code{x} containing diagnostic codes. Codes must be in upper case with no puctuation in order to be properly recognised.}

\item{score}{The comorbidity score to compute. Possible choices are the weighted Charlson score based on ICD-10 codes (\code{charlson_icd10}) and the Elixhauser comorbidity score based on ICD-10 codes (\code{elixhauser_icd10}). Defaults to \code{charlson_icd10}.}

\item{assign0}{Apply a hierarchy of comorbities. If \code{TRUE}, should a comorbidity be present in a patient with different degrees of severity, then the milder form will be assigned to 0 and therefore not counted. By doing this, a type of comorbidity is not counted more than once in each patient.}

\item{factorise}{Return comorbidities as factors rather than numeric, where (1 = presence of comorbidity, 0 = otherwise). Defaults to \code{FALSE}.}

\item{labelled}{Attach labels to each comorbidity, compatible with the RStudio viewer via the \code{\link[utils:View]{utils::View()}} function. Defaults to \code{TRUE}.}

\item{tidy.codes}{Tidy diagnostic codes? If \code{TRUE}, all codes are converted to upper case and all non-alphanumeric characters are removed (REGEXPR: \code{[^[:alnum:]]}). Defaults to \code{TRUE}.}

\item{parallel}{Run the computation in parallel? See the \code{Notes} section for more information. Defaults to \code{FALSE}.}

\item{mc.cores}{The number of cores to use when running the computations in parallel. Defaults to all available cores.}
}
\value{
A data frame with \code{id}, columns relative to each comorbidity domain, comorbidity score, weighted comorbidity score, and categorisations of such scores, with one row per individual.

For the Charlson score, the following variables are included in the dataset:
\itemize{
\item The \code{id} variable as defined by the user;
\item \code{ami}, for acute myocardial infarction;
\item \code{chf}, for congestive heart failure;
\item \code{pvd}, for peripheral vascular disease;
\item \code{cevd}, for cerebrovascular disease;
\item \code{dementia}, for dementia;
\item \code{copd}, chronic obstructive pulmonary disease;
\item \code{rheumd}, for rheumatoid disease;
\item \code{pud}, for peptic ulcer disease;
\item \code{mld}, for mild liver disease;
\item \code{diab}, for diabetes without complications;
\item \code{diabwc}, for diabetes with complications;
\item \code{hp}, for hemiplegia or paraplegia;
\item \code{rend}, for renal disease;
\item \code{canc}, for cancer (any malignancy);
\item \code{msld}, for moderate or severe liver disease;
\item \code{metacanc}, for metastatic solid tumor;
\item \code{aids}, for AIDS/HIV;
\item \code{score}, for the weighted Charlson score;
\item \code{index}, for the grouped Charlson index.
}

Conversely, for the Elixhauser score the dataset contains the following variables:
\itemize{
\item The \code{id} variable as defined by the user;
\item \code{chf}, for congestive heart failure;
\item \code{carit}, for cardiac arrhytmias;
\item \code{valv}, for valvular disease;
\item \code{pcd}, for pulmonary circulation disorders;
\item \code{pvd}, for peripheral vascular disorders;
\item \code{hypunc}, for hypertension, uncomplicated;
\item \code{hypc}, for hypertension, complicated;
\item \code{para}, for paralysis;
\item \code{ond}, for other neurological disorders;
\item \code{cpd}, for chronic pulmonary disease;
\item \code{diabunc}, for diabetes, uncomplicated;
\item \code{diabc}, for diabetes, complicated;
\item \code{hypothy}, for hypothyroidism;
\item \code{rf}, for renal failure;
\item \code{ld}, for liver disease;
\item \code{pud}, for peptic ulcer disease, excluding bleeding;
\item \code{aids}, for AIDS/HIV;
\item \code{lymph}, for lymphoma;
\item \code{metacanc}, for metastatic cancer;
\item \code{solidtum}, for solid tumor, without metastasis;
\item \code{rheumd}, for rheumatoid artritis/collaged vascular disease;
\item \code{coag}, for coagulopaty;
\item \code{obes}, for obesity;
\item \code{wloss}, for weight loss;
\item \code{fed}, for fluid and electrolyte disorders;
\item \code{blane}, for blood loss anemia;
\item \code{dane}, for deficiency anemia;
\item \code{alcohol}, for alcohol abuse;
\item \code{drug}, for drug abuse;
\item \code{psycho}, for psychoses;
\item \code{depre}, for depression.
}

Labels are presented to the user when using the RStudio viewer (e.g. via the \code{\link[utils:View]{utils::View()}} function) for convenience.
}
\description{
Computes comorbidity scores such as the weighted Charlson score and the Elixhauser comorbidity score.
}
\details{
This function is based on the ICD-10-based formulations of the Charlson score and Elixhauser score proposed by Quan \emph{et al}. in 2005. Weights for the Charlson score are based on the original formulation by Charlson \emph{et al}. in 1987, while weights for the Elixhauser score are based on work by van Walraven \emph{et al}. Finally, the categorisation of scores and weighted scores is based on work by Menendez \emph{et al}.
ICD-10 codes must be in upper case and with no punctuation in order to be properly recognised; set \code{tidy.codes = TRUE} to properly tidy the codes automatically.
To run the calculations in parallel set \code{parallel = TRUE}. This is based on \code{\link[parallel:parLapply]{parallel::parLapply()}}, and it is possible to set the number of cores to use via the \code{mc.cores} argument, which defaults to using all the cores available.
}
\examples{
set.seed(1)
x <- data.frame(
  id = sample(1:15, size = 200, replace = TRUE),
  code = sample_diag_icd10(200),
  stringsAsFactors = FALSE)

# Charlson score based on ICD-10 diagnostic codes:
comorbidity(x = x, id = "id", code = "code", score = "charlson_icd10")

# Elixhauser score based on ICD-10 diagnostic codes:
comorbidity(x = x, id = "id", code = "code", score = "elixhauser_icd10")

}
\references{
Quan H, Sundararajan V, Halfon P, Fong A, Burnand B, Luthi J-C, et al. \emph{Coding algorithms for defining comorbidities in ICD-9-CM and ICD-10 administrative data}. Medical Care 2005; 43(11):1130-1139.

Charlson ME, Pompei P, Ales KL, et al. \emph{A new method of classifying prognostic comorbidity in longitudinal studies: development and validation}. Journal of Chronic Diseases 1987; 40:373-383.

van Walraven C, Austin PC, Jennings A, Quan H and Forster AJ. \emph{A modification of the Elixhauser comorbidity measures into a point system for hospital death using administrative data}. Medical Care 2009; 47(6):626-633.

Menendez ME, Neuhaus V, van Dijk CN, Ring D. \emph{The Elixhauser comorbidity method outperforms the Charlson index in predicting inpatient death after orthopaedic surgery}. Clinical Orthopaedics and Related Research 2014; 472:2878–2886.
}
