% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two.level.lindley.LR.R
\name{two.level.lindley.LR}
\alias{two.level.lindley.LR}
\title{Likelihood ratio calculation using Lindley's approach}
\usage{
two.level.lindley.LR(control, recovered, background)
}
\arguments{
\item{control}{a \code{compitem} object with the control item information}

\item{recovered}{a \code{compitem} object with the recovered item information}

\item{background}{a \code{compcovar} object with the population information}
}
\value{
an estimate of the likelihood ratio
}
\description{
Takes a \code{compitem} object which represents some control item, and a
\code{compitem} object which represents a recovered item, then uses information
from a \code{compcovar} object, which represents the information from the
population, to calculate a likelihood ratio as a measure of the evidence
given by the observations for the same/different source propositions.
}
\details{
Does the likelihood ratio calculations for a two-level model
assuming that the between item distribution is univariate normal. This
function is taken from the approach devised by Denis Lindley in his 1977
paper (details below) and represents the progenitor of all the functions in
this package.
}
\examples{
# load Greg Zadora's glass data
data(glass)

# calculate a compcovar object based upon dat
# using K
Z = two.level.components(glass, 7, 1)

# calculate a compitem object representing the control item
control = two.level.comparison.items(glass[1:6,], 7)

# calculate a compitem object representing the recovered item
# known to be from the same item (item 1)
recovered.1 = two.level.comparison.items(glass[7:12,], 7)

# calculate a compitem object representing the recovered item
# known to be from a different item (item 2)
recovered.2 = two.level.comparison.items(glass[19:24,], 7)


# calculate the likelihood ratio for a known
# same source comparison - should be 6.323941
# This value is 6.323327 in this version and in the last version written by David (1.0-4)
lr.1 = two.level.lindley.LR(control, recovered.1, Z)
lr.1

# calculate the likelihood ratio for a known
# different source comparison - should be 0.004422907
# This value is 0.004421978 in this version and the last version written by David (1.0-4)
lr.2 = two.level.lindley.LR(control, recovered.2, Z)
lr.2
}
\references{
Lindley, D. (1977) A problem in forensic Science. \emph{Biometrika}: \bold{64}; 207-213.
}
\author{
David Lucy
}
