% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{LossCustomCpp}
\alias{LossCustomCpp}
\title{Create custom cpp losses by using cpp functions and external pointer.}
\format{\code{\link{S4}} object.}
\description{
\code{LossCustomCpp} creates a custom loss by using
\code{Rcpp::XPtr} to set \code{C++} functions.
}
\section{Usage}{

\preformatted{
LossCustomCpp$new(loss_ptr, grad_ptr, const_init_ptr)
}
}

\section{Arguments}{

\describe{
\item{\code{loss_ptr} [\code{externalptr}]}{
  External pointer to the \code{C++} loss function.
}
\item{\code{grad_ptr} [\code{externalptr}]}{
  External pointer to the \code{C++} gradient function.
}
\item{\code{const_init_ptr} [\code{externalptr}]}{
  External pointer to the \code{C++} constant initialization function.
}
}
}

\section{Details}{

  For an example see the extending compboost vignette or the function
  \code{getCustomCppExample(example = "loss")}.

  This class is a wrapper around the pure \code{C++} implementation. To see
  the functionality of the \code{C++} class visit
  \url{https://schalkdaniel.github.io/compboost/cpp_man/html/classloss_1_1_custom_cpp_loss.html}.
}

\examples{
\donttest{
# Load loss functions:
Rcpp::sourceCpp(code = getCustomCppExample(example = "loss", silent = TRUE))

# Create new custom quadratic loss:
my.cpp.loss = LossCustomCpp$new(lossFunSetter(), gradFunSetter(), constInitFunSetter())
}
}
