% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medians.R
\name{mahalanobis}
\alias{mahalanobis}
\title{Mahalanobis Distance, with better complex behavior}
\usage{
mahalanobis(x, center, cov, pcov = NULL, inverted = FALSE, ...)
}
\arguments{
\item{x}{A length \eqn{p} vector or matrix with row length \eqn{p}. Or, a length \eqn{2p} vector or matrix with row length \eqn{2p}.}

\item{center}{A vector of length equal to that of \code{x}.}

\item{cov}{The covariance matrix \eqn{(p x p)} of the distribution. Or, the "double covariance matrix" of the distribution, which contains the information from \code{cov} and \code{pcov} in a single \eqn{(2p x 2p)} matrix.
Can be generated by \link{matrixweave}, \link{vcov.zlm}, or \link{vcov.rzlm}.
vcov.rzlm].}

\item{pcov}{The pseudo covariance matrix \eqn{(p x p)} of the distribution. Optional.}

\item{inverted}{Boolean, if TRUE, \code{cov} and \code{pcov} are not taken to be the \emph{inverse} covariance and pseudo covariance matrices.}

\item{...}{Optional arguments to be passed to \link{solve}, which is used for computing the inverse of \code{cov}. If \code{inverted = TRUE}, unused.}
}
\value{
numeric. The squared Mahalanobis distance (divergence) between \code{x} and \code{center}.
}
\description{
The Mahalanobis distance function included in the \code{stats} package returns a complex number when given complex values of \code{x}.
But a distance (and thus its square) is always positive real. This function calculates the Mahalanobis distance using
the conjugate transpose if given complex data, otherwise it calls \link[stats:mahalanobis]{stats::mahalanobis}.
}
\details{
Depending on the relative sizes of \code{x}, \code{cov}, and \code{pcov}, the function will perform slightly different calculations. If \code{pcov} is not included,
the Mahalanobis distance is calculated using only \code{cov}. In this case if the dimension of \code{cov} is twice that of \code{x}, \code{x} is interleaved with its complex conjugate
so that it becomes the same length as \code{cov}. Note that in this case the resulting Mahalanobis distance will only incorporate information about the interactions between
the real and imaginary components if the "double covariance matrix is given as \code{cov} . If \code{pcov} is included in the input, \code{pcov} and \code{cov} are interleaved to form the "double covariance", and this is used to
calculate the Mahalanobis distance, interleaving \code{x} if necessary. This gives the user a great deal of flexibility when it comes to input.
}
\examples{
set.seed(4242)
n <- 8
x <- matrix(complex(real = rnorm(n), imaginary = rnorm(n)), ncol = 2)
mu <- complex(real = 1.4, imaginary = 0.4)
sigma <- 3.4
mahalanobis(x, mu, sigma * diag(2))
}
\references{
D. Dai and Y. Liang, High-Dimensional Mahalanobis Distances of Complex Random Vectors, Mathematics 9, 1877 (2021).
}
\seealso{
\link{matrixweave}
}
