% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Det.R
\name{Det}
\alias{Det}
\title{Compute the Determinant of a Matrix}
\usage{
Det(M)
}
\arguments{
\item{M}{a square matrix, real or complex.}
}
\value{
The determinant of M.
}
\description{
\code{Det} computes the determinant of a square matrix.
If the matrix is complex, the determinant is computed as the product of the eigenvalues; if the matrix
is real, \code{Det} calls the base function \code{det} for maximum efficiency.
}
\examples{
A <- matrix(c(1, 2, 2+3i, 5), ncol = 2) #complex matrix
B <- matrix(1:4, ncol = 2) #real matrix

Det(A)
Det(B)

}
\author{
Albert Dorador
}

